package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{RamdiskId, KernelId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RegisterImageRequest(
    imageLocation: Option[String] = None,
    architecture: Option[zio.aws.ec2.model.ArchitectureValues] = None,
    blockDeviceMappings: Option[
      Iterable[zio.aws.ec2.model.BlockDeviceMapping]
    ] = None,
    description: Option[String] = None,
    enaSupport: Option[Boolean] = None,
    kernelId: Option[KernelId] = None,
    name: String,
    billingProducts: Option[Iterable[String]] = None,
    ramdiskId: Option[RamdiskId] = None,
    rootDeviceName: Option[String] = None,
    sriovNetSupport: Option[String] = None,
    virtualizationType: Option[String] = None,
    bootMode: Option[zio.aws.ec2.model.BootModeValues] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RegisterImageRequest = {
    import RegisterImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RegisterImageRequest
      .builder()
      .optionallyWith(imageLocation.map(value => value: java.lang.String))(
        _.imageLocation
      )
      .optionallyWith(architecture.map(value => value.unwrap))(_.architecture)
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(enaSupport.map(value => value: java.lang.Boolean))(
        _.enaSupport
      )
      .optionallyWith(
        kernelId.map(value => KernelId.unwrap(value): java.lang.String)
      )(_.kernelId)
      .name(name: java.lang.String)
      .optionallyWith(
        billingProducts.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.billingProducts)
      .optionallyWith(
        ramdiskId.map(value => RamdiskId.unwrap(value): java.lang.String)
      )(_.ramdiskId)
      .optionallyWith(rootDeviceName.map(value => value: java.lang.String))(
        _.rootDeviceName
      )
      .optionallyWith(sriovNetSupport.map(value => value: java.lang.String))(
        _.sriovNetSupport
      )
      .optionallyWith(virtualizationType.map(value => value: java.lang.String))(
        _.virtualizationType
      )
      .optionallyWith(bootMode.map(value => value.unwrap))(_.bootMode)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RegisterImageRequest.ReadOnly =
    zio.aws.ec2.model.RegisterImageRequest.wrap(buildAwsValue())
}
object RegisterImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RegisterImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RegisterImageRequest =
      zio.aws.ec2.model.RegisterImageRequest(
        imageLocation.map(value => value),
        architecture.map(value => value),
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        description.map(value => value),
        enaSupport.map(value => value),
        kernelId.map(value => value),
        name,
        billingProducts.map(value => value),
        ramdiskId.map(value => value),
        rootDeviceName.map(value => value),
        sriovNetSupport.map(value => value),
        virtualizationType.map(value => value),
        bootMode.map(value => value)
      )
    def imageLocation: Option[String]
    def architecture: Option[zio.aws.ec2.model.ArchitectureValues]
    def blockDeviceMappings
        : Option[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]]
    def description: Option[String]
    def enaSupport: Option[Boolean]
    def kernelId: Option[KernelId]
    def name: String
    def billingProducts: Option[List[String]]
    def ramdiskId: Option[RamdiskId]
    def rootDeviceName: Option[String]
    def sriovNetSupport: Option[String]
    def virtualizationType: Option[String]
    def bootMode: Option[zio.aws.ec2.model.BootModeValues]
    def getImageLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageLocation", imageLocation)
    def getArchitecture
        : ZIO[Any, AwsError, zio.aws.ec2.model.ArchitectureValues] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.BlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEnaSupport: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enaSupport", enaSupport)
    def getKernelId: ZIO[Any, AwsError, KernelId] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getBillingProducts: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("billingProducts", billingProducts)
    def getRamdiskId: ZIO[Any, AwsError, RamdiskId] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getRootDeviceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rootDeviceName", rootDeviceName)
    def getSriovNetSupport: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sriovNetSupport", sriovNetSupport)
    def getVirtualizationType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("virtualizationType", virtualizationType)
    def getBootMode: ZIO[Any, AwsError, zio.aws.ec2.model.BootModeValues] =
      AwsError.unwrapOptionField("bootMode", bootMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RegisterImageRequest
  ) extends zio.aws.ec2.model.RegisterImageRequest.ReadOnly {
    override val imageLocation: Option[String] =
      scala.Option(impl.imageLocation()).map(value => value: String)
    override val architecture: Option[zio.aws.ec2.model.ArchitectureValues] =
      scala
        .Option(impl.architecture())
        .map(value => zio.aws.ec2.model.ArchitectureValues.wrap(value))
    override val blockDeviceMappings
        : Option[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]] = scala
      .Option(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.BlockDeviceMapping.wrap(item)
        }.toList
      )
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val enaSupport: Option[Boolean] =
      scala.Option(impl.enaSupport()).map(value => value: Boolean)
    override val kernelId: Option[KernelId] = scala
      .Option(impl.kernelId())
      .map(value => zio.aws.ec2.model.primitives.KernelId(value))
    override val name: String = impl.name(): String
    override val billingProducts: Option[List[String]] = scala
      .Option(impl.billingProducts())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val ramdiskId: Option[RamdiskId] = scala
      .Option(impl.ramdiskId())
      .map(value => zio.aws.ec2.model.primitives.RamdiskId(value))
    override val rootDeviceName: Option[String] =
      scala.Option(impl.rootDeviceName()).map(value => value: String)
    override val sriovNetSupport: Option[String] =
      scala.Option(impl.sriovNetSupport()).map(value => value: String)
    override val virtualizationType: Option[String] =
      scala.Option(impl.virtualizationType()).map(value => value: String)
    override val bootMode: Option[zio.aws.ec2.model.BootModeValues] = scala
      .Option(impl.bootMode())
      .map(value => zio.aws.ec2.model.BootModeValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RegisterImageRequest
  ): zio.aws.ec2.model.RegisterImageRequest.ReadOnly = new Wrapper(impl)
}
