package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PrefixListId(
    description: Option[String] = None,
    prefixListId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PrefixListId = {
    import PrefixListId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PrefixListId
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(prefixListId.map(value => value: java.lang.String))(
        _.prefixListId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PrefixListId.ReadOnly =
    zio.aws.ec2.model.PrefixListId.wrap(buildAwsValue())
}
object PrefixListId {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.PrefixListId] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PrefixListId =
      zio.aws.ec2.model.PrefixListId(
        description.map(value => value),
        prefixListId.map(value => value)
      )
    def description: Option[String]
    def prefixListId: Option[String]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getPrefixListId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefixListId", prefixListId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PrefixListId
  ) extends zio.aws.ec2.model.PrefixListId.ReadOnly {
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val prefixListId: Option[String] =
      scala.Option(impl.prefixListId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PrefixListId
  ): zio.aws.ec2.model.PrefixListId.ReadOnly = new Wrapper(impl)
}
