package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PeeringAttachmentStatus(
    code: Option[String] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PeeringAttachmentStatus = {
    import PeeringAttachmentStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PeeringAttachmentStatus
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PeeringAttachmentStatus.ReadOnly =
    zio.aws.ec2.model.PeeringAttachmentStatus.wrap(buildAwsValue())
}
object PeeringAttachmentStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PeeringAttachmentStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PeeringAttachmentStatus =
      zio.aws.ec2.model.PeeringAttachmentStatus(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Option[String]
    def message: Option[String]
    def getCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PeeringAttachmentStatus
  ) extends zio.aws.ec2.model.PeeringAttachmentStatus.ReadOnly {
    override val code: Option[String] =
      scala.Option(impl.code()).map(value => value: String)
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PeeringAttachmentStatus
  ): zio.aws.ec2.model.PeeringAttachmentStatus.ReadOnly = new Wrapper(impl)
}
