package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait PaymentOption {
  def unwrap: software.amazon.awssdk.services.ec2.model.PaymentOption
}
object PaymentOption {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.PaymentOption
  ): zio.aws.ec2.model.PaymentOption = value match {
    case software.amazon.awssdk.services.ec2.model.PaymentOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.PaymentOption.ALL_UPFRONT =>
      val r = AllUpfront
      r
    case software.amazon.awssdk.services.ec2.model.PaymentOption.PARTIAL_UPFRONT =>
      val r = PartialUpfront
      r
    case software.amazon.awssdk.services.ec2.model.PaymentOption.NO_UPFRONT =>
      val r = NoUpfront
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.PaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PaymentOption =
      software.amazon.awssdk.services.ec2.model.PaymentOption.UNKNOWN_TO_SDK_VERSION
  }
  case object AllUpfront extends zio.aws.ec2.model.PaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PaymentOption =
      software.amazon.awssdk.services.ec2.model.PaymentOption.ALL_UPFRONT
  }
  case object PartialUpfront extends zio.aws.ec2.model.PaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PaymentOption =
      software.amazon.awssdk.services.ec2.model.PaymentOption.PARTIAL_UPFRONT
  }
  case object NoUpfront extends zio.aws.ec2.model.PaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PaymentOption =
      software.amazon.awssdk.services.ec2.model.PaymentOption.NO_UPFRONT
  }
}
