package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait OperationType {
  def unwrap: software.amazon.awssdk.services.ec2.model.OperationType
}
object OperationType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.OperationType
  ): zio.aws.ec2.model.OperationType = value match {
    case software.amazon.awssdk.services.ec2.model.OperationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.OperationType.ADD =>
      val r = add
      r
    case software.amazon.awssdk.services.ec2.model.OperationType.REMOVE =>
      val r = remove
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.OperationType =
      software.amazon.awssdk.services.ec2.model.OperationType.UNKNOWN_TO_SDK_VERSION
  }
  case object add extends zio.aws.ec2.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.OperationType =
      software.amazon.awssdk.services.ec2.model.OperationType.ADD
  }
  case object remove extends zio.aws.ec2.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.OperationType =
      software.amazon.awssdk.services.ec2.model.OperationType.REMOVE
  }
}
