package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, DateTime}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class NetworkInterfaceAttachment(
    attachTime: Option[DateTime] = None,
    attachmentId: Option[String] = None,
    deleteOnTermination: Option[Boolean] = None,
    deviceIndex: Option[Integer] = None,
    networkCardIndex: Option[Integer] = None,
    instanceId: Option[String] = None,
    instanceOwnerId: Option[String] = None,
    status: Option[zio.aws.ec2.model.AttachmentStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttachment = {
    import NetworkInterfaceAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttachment
      .builder()
      .optionallyWith(attachTime.map(value => DateTime.unwrap(value): Instant))(
        _.attachTime
      )
      .optionallyWith(attachmentId.map(value => value: java.lang.String))(
        _.attachmentId
      )
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .optionallyWith(deviceIndex.map(value => value: java.lang.Integer))(
        _.deviceIndex
      )
      .optionallyWith(networkCardIndex.map(value => value: java.lang.Integer))(
        _.networkCardIndex
      )
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(instanceOwnerId.map(value => value: java.lang.String))(
        _.instanceOwnerId
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkInterfaceAttachment.ReadOnly =
    zio.aws.ec2.model.NetworkInterfaceAttachment.wrap(buildAwsValue())
}
object NetworkInterfaceAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInterfaceAttachment =
      zio.aws.ec2.model.NetworkInterfaceAttachment(
        attachTime.map(value => value),
        attachmentId.map(value => value),
        deleteOnTermination.map(value => value),
        deviceIndex.map(value => value),
        networkCardIndex.map(value => value),
        instanceId.map(value => value),
        instanceOwnerId.map(value => value),
        status.map(value => value)
      )
    def attachTime: Option[DateTime]
    def attachmentId: Option[String]
    def deleteOnTermination: Option[Boolean]
    def deviceIndex: Option[Integer]
    def networkCardIndex: Option[Integer]
    def instanceId: Option[String]
    def instanceOwnerId: Option[String]
    def status: Option[zio.aws.ec2.model.AttachmentStatus]
    def getAttachTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("attachTime", attachTime)
    def getAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attachmentId", attachmentId)
    def getDeleteOnTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
    def getDeviceIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("deviceIndex", deviceIndex)
    def getNetworkCardIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("networkCardIndex", networkCardIndex)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceOwnerId", instanceOwnerId)
    def getStatus: ZIO[Any, AwsError, zio.aws.ec2.model.AttachmentStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttachment
  ) extends zio.aws.ec2.model.NetworkInterfaceAttachment.ReadOnly {
    override val attachTime: Option[DateTime] = scala
      .Option(impl.attachTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val attachmentId: Option[String] =
      scala.Option(impl.attachmentId()).map(value => value: String)
    override val deleteOnTermination: Option[Boolean] =
      scala.Option(impl.deleteOnTermination()).map(value => value: Boolean)
    override val deviceIndex: Option[Integer] =
      scala.Option(impl.deviceIndex()).map(value => value: Integer)
    override val networkCardIndex: Option[Integer] =
      scala.Option(impl.networkCardIndex()).map(value => value: Integer)
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
    override val instanceOwnerId: Option[String] =
      scala.Option(impl.instanceOwnerId()).map(value => value: String)
    override val status: Option[zio.aws.ec2.model.AttachmentStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ec2.model.AttachmentStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttachment
  ): zio.aws.ec2.model.NetworkInterfaceAttachment.ReadOnly = new Wrapper(impl)
}
