package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyVpcPeeringConnectionOptionsResponse(
    accepterPeeringConnectionOptions: Option[
      zio.aws.ec2.model.PeeringConnectionOptions
    ] = None,
    requesterPeeringConnectionOptions: Option[
      zio.aws.ec2.model.PeeringConnectionOptions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsResponse = {
    import ModifyVpcPeeringConnectionOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsResponse
      .builder()
      .optionallyWith(
        accepterPeeringConnectionOptions.map(value => value.buildAwsValue())
      )(_.accepterPeeringConnectionOptions)
      .optionallyWith(
        requesterPeeringConnectionOptions.map(value => value.buildAwsValue())
      )(_.requesterPeeringConnectionOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsResponse.ReadOnly =
    zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsResponse
      .wrap(buildAwsValue())
}
object ModifyVpcPeeringConnectionOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsResponse =
      zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsResponse(
        accepterPeeringConnectionOptions.map(value => value.asEditable),
        requesterPeeringConnectionOptions.map(value => value.asEditable)
      )
    def accepterPeeringConnectionOptions
        : Option[zio.aws.ec2.model.PeeringConnectionOptions.ReadOnly]
    def requesterPeeringConnectionOptions
        : Option[zio.aws.ec2.model.PeeringConnectionOptions.ReadOnly]
    def getAccepterPeeringConnectionOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.PeeringConnectionOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accepterPeeringConnectionOptions",
      accepterPeeringConnectionOptions
    )
    def getRequesterPeeringConnectionOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.PeeringConnectionOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "requesterPeeringConnectionOptions",
      requesterPeeringConnectionOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsResponse
  ) extends zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsResponse.ReadOnly {
    override val accepterPeeringConnectionOptions
        : Option[zio.aws.ec2.model.PeeringConnectionOptions.ReadOnly] = scala
      .Option(impl.accepterPeeringConnectionOptions())
      .map(value => zio.aws.ec2.model.PeeringConnectionOptions.wrap(value))
    override val requesterPeeringConnectionOptions
        : Option[zio.aws.ec2.model.PeeringConnectionOptions.ReadOnly] = scala
      .Option(impl.requesterPeeringConnectionOptions())
      .map(value => zio.aws.ec2.model.PeeringConnectionOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsResponse
  ): zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsResponse.ReadOnly =
    new Wrapper(impl)
}
