package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VolumeId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyVolumeAttributeRequest(
    autoEnableIO: Option[zio.aws.ec2.model.AttributeBooleanValue] = None,
    volumeId: VolumeId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeRequest = {
    import ModifyVolumeAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeRequest
      .builder()
      .optionallyWith(autoEnableIO.map(value => value.buildAwsValue()))(
        _.autoEnableIO
      )
      .volumeId(VolumeId.unwrap(volumeId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyVolumeAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVolumeAttributeRequest.wrap(buildAwsValue())
}
object ModifyVolumeAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVolumeAttributeRequest =
      zio.aws.ec2.model.ModifyVolumeAttributeRequest(
        autoEnableIO.map(value => value.asEditable),
        volumeId
      )
    def autoEnableIO: Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def volumeId: VolumeId
    def getAutoEnableIO
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("autoEnableIO", autoEnableIO)
    def getVolumeId: ZIO[Any, Nothing, VolumeId] = ZIO.succeed(volumeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeRequest
  ) extends zio.aws.ec2.model.ModifyVolumeAttributeRequest.ReadOnly {
    override val autoEnableIO
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.autoEnableIO())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val volumeId: VolumeId =
      zio.aws.ec2.model.primitives.VolumeId(impl.volumeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeRequest
  ): zio.aws.ec2.model.ModifyVolumeAttributeRequest.ReadOnly = new Wrapper(impl)
}
