package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyIpamRequest(
    ipamId: IpamId,
    description: Option[String] = None,
    addOperatingRegions: Option[
      Iterable[zio.aws.ec2.model.AddIpamOperatingRegion]
    ] = None,
    removeOperatingRegions: Option[
      Iterable[zio.aws.ec2.model.RemoveIpamOperatingRegion]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyIpamRequest = {
    import ModifyIpamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyIpamRequest
      .builder()
      .ipamId(IpamId.unwrap(ipamId): java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        addOperatingRegions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addOperatingRegions)
      .optionallyWith(
        removeOperatingRegions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.removeOperatingRegions)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyIpamRequest.ReadOnly =
    zio.aws.ec2.model.ModifyIpamRequest.wrap(buildAwsValue())
}
object ModifyIpamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyIpamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyIpamRequest =
      zio.aws.ec2.model.ModifyIpamRequest(
        ipamId,
        description.map(value => value),
        addOperatingRegions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        removeOperatingRegions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def ipamId: IpamId
    def description: Option[String]
    def addOperatingRegions
        : Option[List[zio.aws.ec2.model.AddIpamOperatingRegion.ReadOnly]]
    def removeOperatingRegions
        : Option[List[zio.aws.ec2.model.RemoveIpamOperatingRegion.ReadOnly]]
    def getIpamId: ZIO[Any, Nothing, IpamId] = ZIO.succeed(ipamId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getAddOperatingRegions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AddIpamOperatingRegion.ReadOnly
    ]] = AwsError.unwrapOptionField("addOperatingRegions", addOperatingRegions)
    def getRemoveOperatingRegions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.RemoveIpamOperatingRegion.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "removeOperatingRegions",
      removeOperatingRegions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIpamRequest
  ) extends zio.aws.ec2.model.ModifyIpamRequest.ReadOnly {
    override val ipamId: IpamId =
      zio.aws.ec2.model.primitives.IpamId(impl.ipamId())
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val addOperatingRegions
        : Option[List[zio.aws.ec2.model.AddIpamOperatingRegion.ReadOnly]] =
      scala
        .Option(impl.addOperatingRegions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AddIpamOperatingRegion.wrap(item)
          }.toList
        )
    override val removeOperatingRegions
        : Option[List[zio.aws.ec2.model.RemoveIpamOperatingRegion.ReadOnly]] =
      scala
        .Option(impl.removeOperatingRegions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.RemoveIpamOperatingRegion.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIpamRequest
  ): zio.aws.ec2.model.ModifyIpamRequest.ReadOnly = new Wrapper(impl)
}
