package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyInstanceMaintenanceOptionsResponse(
    instanceId: Option[String] = None,
    autoRecovery: Option[zio.aws.ec2.model.InstanceAutoRecoveryState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyInstanceMaintenanceOptionsResponse = {
    import ModifyInstanceMaintenanceOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyInstanceMaintenanceOptionsResponse
      .builder()
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(autoRecovery.map(value => value.unwrap))(_.autoRecovery)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyInstanceMaintenanceOptionsResponse.ReadOnly =
    zio.aws.ec2.model.ModifyInstanceMaintenanceOptionsResponse
      .wrap(buildAwsValue())
}
object ModifyInstanceMaintenanceOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyInstanceMaintenanceOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyInstanceMaintenanceOptionsResponse =
      zio.aws.ec2.model.ModifyInstanceMaintenanceOptionsResponse(
        instanceId.map(value => value),
        autoRecovery.map(value => value)
      )
    def instanceId: Option[String]
    def autoRecovery: Option[zio.aws.ec2.model.InstanceAutoRecoveryState]
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getAutoRecovery
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceAutoRecoveryState] =
      AwsError.unwrapOptionField("autoRecovery", autoRecovery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceMaintenanceOptionsResponse
  ) extends zio.aws.ec2.model.ModifyInstanceMaintenanceOptionsResponse.ReadOnly {
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
    override val autoRecovery
        : Option[zio.aws.ec2.model.InstanceAutoRecoveryState] = scala
      .Option(impl.autoRecovery())
      .map(value => zio.aws.ec2.model.InstanceAutoRecoveryState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceMaintenanceOptionsResponse
  ): zio.aws.ec2.model.ModifyInstanceMaintenanceOptionsResponse.ReadOnly =
    new Wrapper(impl)
}
