package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  DateTime,
  VersionDescription,
  LaunchTemplateName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class LaunchTemplateVersion(
    launchTemplateId: Option[String] = None,
    launchTemplateName: Option[LaunchTemplateName] = None,
    versionNumber: Option[Long] = None,
    versionDescription: Option[VersionDescription] = None,
    createTime: Option[DateTime] = None,
    createdBy: Option[String] = None,
    defaultVersion: Option[Boolean] = None,
    launchTemplateData: Option[zio.aws.ec2.model.ResponseLaunchTemplateData] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateVersion = {
    import LaunchTemplateVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateVersion
      .builder()
      .optionallyWith(launchTemplateId.map(value => value: java.lang.String))(
        _.launchTemplateId
      )
      .optionallyWith(
        launchTemplateName.map(value =>
          LaunchTemplateName.unwrap(value): java.lang.String
        )
      )(_.launchTemplateName)
      .optionallyWith(versionNumber.map(value => value: java.lang.Long))(
        _.versionNumber
      )
      .optionallyWith(
        versionDescription.map(value =>
          VersionDescription.unwrap(value): java.lang.String
        )
      )(_.versionDescription)
      .optionallyWith(createTime.map(value => DateTime.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(defaultVersion.map(value => value: java.lang.Boolean))(
        _.defaultVersion
      )
      .optionallyWith(launchTemplateData.map(value => value.buildAwsValue()))(
        _.launchTemplateData
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LaunchTemplateVersion.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateVersion.wrap(buildAwsValue())
}
object LaunchTemplateVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplateVersion =
      zio.aws.ec2.model.LaunchTemplateVersion(
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        versionNumber.map(value => value),
        versionDescription.map(value => value),
        createTime.map(value => value),
        createdBy.map(value => value),
        defaultVersion.map(value => value),
        launchTemplateData.map(value => value.asEditable)
      )
    def launchTemplateId: Option[String]
    def launchTemplateName: Option[LaunchTemplateName]
    def versionNumber: Option[Long]
    def versionDescription: Option[VersionDescription]
    def createTime: Option[DateTime]
    def createdBy: Option[String]
    def defaultVersion: Option[Boolean]
    def launchTemplateData
        : Option[zio.aws.ec2.model.ResponseLaunchTemplateData.ReadOnly]
    def getLaunchTemplateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, LaunchTemplateName] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getVersionNumber: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
    def getVersionDescription: ZIO[Any, AwsError, VersionDescription] =
      AwsError.unwrapOptionField("versionDescription", versionDescription)
    def getCreateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getDefaultVersion: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultVersion", defaultVersion)
    def getLaunchTemplateData: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ResponseLaunchTemplateData.ReadOnly
    ] = AwsError.unwrapOptionField("launchTemplateData", launchTemplateData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateVersion
  ) extends zio.aws.ec2.model.LaunchTemplateVersion.ReadOnly {
    override val launchTemplateId: Option[String] =
      scala.Option(impl.launchTemplateId()).map(value => value: String)
    override val launchTemplateName: Option[LaunchTemplateName] = scala
      .Option(impl.launchTemplateName())
      .map(value => zio.aws.ec2.model.primitives.LaunchTemplateName(value))
    override val versionNumber: Option[Long] =
      scala.Option(impl.versionNumber()).map(value => value: Long)
    override val versionDescription: Option[VersionDescription] = scala
      .Option(impl.versionDescription())
      .map(value => zio.aws.ec2.model.primitives.VersionDescription(value))
    override val createTime: Option[DateTime] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val createdBy: Option[String] =
      scala.Option(impl.createdBy()).map(value => value: String)
    override val defaultVersion: Option[Boolean] =
      scala.Option(impl.defaultVersion()).map(value => value: Boolean)
    override val launchTemplateData
        : Option[zio.aws.ec2.model.ResponseLaunchTemplateData.ReadOnly] = scala
      .Option(impl.launchTemplateData())
      .map(value => zio.aws.ec2.model.ResponseLaunchTemplateData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateVersion
  ): zio.aws.ec2.model.LaunchTemplateVersion.ReadOnly = new Wrapper(impl)
}
