package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateInstanceMaintenanceOptionsRequest(
    autoRecovery: Option[zio.aws.ec2.model.LaunchTemplateAutoRecoveryState] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest = {
    import LaunchTemplateInstanceMaintenanceOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest
      .builder()
      .optionallyWith(autoRecovery.map(value => value.unwrap))(_.autoRecovery)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest
      .wrap(buildAwsValue())
}
object LaunchTemplateInstanceMaintenanceOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest =
      zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest(
        autoRecovery.map(value => value)
      )
    def autoRecovery: Option[zio.aws.ec2.model.LaunchTemplateAutoRecoveryState]
    def getAutoRecovery: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateAutoRecoveryState
    ] = AwsError.unwrapOptionField("autoRecovery", autoRecovery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest
  ) extends zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest.ReadOnly {
    override val autoRecovery
        : Option[zio.aws.ec2.model.LaunchTemplateAutoRecoveryState] = scala
      .Option(impl.autoRecovery())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateAutoRecoveryState.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest
  ): zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
