package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait Ipv6SupportValue {
  def unwrap: software.amazon.awssdk.services.ec2.model.Ipv6SupportValue
}
object Ipv6SupportValue {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.Ipv6SupportValue
  ): zio.aws.ec2.model.Ipv6SupportValue = value match {
    case software.amazon.awssdk.services.ec2.model.Ipv6SupportValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.Ipv6SupportValue.ENABLE =>
      val r = enable
      r
    case software.amazon.awssdk.services.ec2.model.Ipv6SupportValue.DISABLE =>
      val r = disable
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.Ipv6SupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.Ipv6SupportValue =
      software.amazon.awssdk.services.ec2.model.Ipv6SupportValue.UNKNOWN_TO_SDK_VERSION
  }
  case object enable extends zio.aws.ec2.model.Ipv6SupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.Ipv6SupportValue =
      software.amazon.awssdk.services.ec2.model.Ipv6SupportValue.ENABLE
  }
  case object disable extends zio.aws.ec2.model.Ipv6SupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.Ipv6SupportValue =
      software.amazon.awssdk.services.ec2.model.Ipv6SupportValue.DISABLE
  }
}
