package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Ipv6Pool(
    poolId: Option[String] = None,
    description: Option[String] = None,
    poolCidrBlocks: Option[Iterable[zio.aws.ec2.model.PoolCidrBlock]] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Ipv6Pool = {
    import Ipv6Pool.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Ipv6Pool
      .builder()
      .optionallyWith(poolId.map(value => value: java.lang.String))(_.poolId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        poolCidrBlocks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.poolCidrBlocks)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Ipv6Pool.ReadOnly =
    zio.aws.ec2.model.Ipv6Pool.wrap(buildAwsValue())
}
object Ipv6Pool {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Ipv6Pool] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Ipv6Pool = zio.aws.ec2.model.Ipv6Pool(
      poolId.map(value => value),
      description.map(value => value),
      poolCidrBlocks.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def poolId: Option[String]
    def description: Option[String]
    def poolCidrBlocks: Option[List[zio.aws.ec2.model.PoolCidrBlock.ReadOnly]]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getPoolId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("poolId", poolId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getPoolCidrBlocks
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PoolCidrBlock.ReadOnly]] =
      AwsError.unwrapOptionField("poolCidrBlocks", poolCidrBlocks)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Ipv6Pool
  ) extends zio.aws.ec2.model.Ipv6Pool.ReadOnly {
    override val poolId: Option[String] =
      scala.Option(impl.poolId()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val poolCidrBlocks
        : Option[List[zio.aws.ec2.model.PoolCidrBlock.ReadOnly]] = scala
      .Option(impl.poolCidrBlocks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.PoolCidrBlock.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Ipv6Pool
  ): zio.aws.ec2.model.Ipv6Pool.ReadOnly = new Wrapper(impl)
}
