package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DiskSize
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceStorageInfo(
    totalSizeInGB: Option[DiskSize] = None,
    disks: Option[Iterable[zio.aws.ec2.model.DiskInfo]] = None,
    nvmeSupport: Option[zio.aws.ec2.model.EphemeralNvmeSupport] = None,
    encryptionSupport: Option[
      zio.aws.ec2.model.InstanceStorageEncryptionSupport
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceStorageInfo = {
    import InstanceStorageInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceStorageInfo
      .builder()
      .optionallyWith(
        totalSizeInGB.map(value => DiskSize.unwrap(value): java.lang.Long)
      )(_.totalSizeInGB)
      .optionallyWith(
        disks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.disks)
      .optionallyWith(nvmeSupport.map(value => value.unwrap))(_.nvmeSupport)
      .optionallyWith(encryptionSupport.map(value => value.unwrap))(
        _.encryptionSupport
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceStorageInfo.ReadOnly =
    zio.aws.ec2.model.InstanceStorageInfo.wrap(buildAwsValue())
}
object InstanceStorageInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceStorageInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceStorageInfo =
      zio.aws.ec2.model.InstanceStorageInfo(
        totalSizeInGB.map(value => value),
        disks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nvmeSupport.map(value => value),
        encryptionSupport.map(value => value)
      )
    def totalSizeInGB: Option[DiskSize]
    def disks: Option[List[zio.aws.ec2.model.DiskInfo.ReadOnly]]
    def nvmeSupport: Option[zio.aws.ec2.model.EphemeralNvmeSupport]
    def encryptionSupport
        : Option[zio.aws.ec2.model.InstanceStorageEncryptionSupport]
    def getTotalSizeInGB: ZIO[Any, AwsError, DiskSize] =
      AwsError.unwrapOptionField("totalSizeInGB", totalSizeInGB)
    def getDisks
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.DiskInfo.ReadOnly]] =
      AwsError.unwrapOptionField("disks", disks)
    def getNvmeSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.EphemeralNvmeSupport] =
      AwsError.unwrapOptionField("nvmeSupport", nvmeSupport)
    def getEncryptionSupport: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceStorageEncryptionSupport
    ] = AwsError.unwrapOptionField("encryptionSupport", encryptionSupport)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceStorageInfo
  ) extends zio.aws.ec2.model.InstanceStorageInfo.ReadOnly {
    override val totalSizeInGB: Option[DiskSize] = scala
      .Option(impl.totalSizeInGB())
      .map(value => zio.aws.ec2.model.primitives.DiskSize(value))
    override val disks: Option[List[zio.aws.ec2.model.DiskInfo.ReadOnly]] =
      scala
        .Option(impl.disks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.DiskInfo.wrap(item)
          }.toList
        )
    override val nvmeSupport: Option[zio.aws.ec2.model.EphemeralNvmeSupport] =
      scala
        .Option(impl.nvmeSupport())
        .map(value => zio.aws.ec2.model.EphemeralNvmeSupport.wrap(value))
    override val encryptionSupport
        : Option[zio.aws.ec2.model.InstanceStorageEncryptionSupport] = scala
      .Option(impl.encryptionSupport())
      .map(value =>
        zio.aws.ec2.model.InstanceStorageEncryptionSupport.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceStorageInfo
  ): zio.aws.ec2.model.InstanceStorageInfo.ReadOnly = new Wrapper(impl)
}
