package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceCapacity(
    availableCapacity: Option[Integer] = None,
    instanceType: Option[String] = None,
    totalCapacity: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceCapacity = {
    import InstanceCapacity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceCapacity
      .builder()
      .optionallyWith(availableCapacity.map(value => value: java.lang.Integer))(
        _.availableCapacity
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(totalCapacity.map(value => value: java.lang.Integer))(
        _.totalCapacity
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceCapacity.ReadOnly =
    zio.aws.ec2.model.InstanceCapacity.wrap(buildAwsValue())
}
object InstanceCapacity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceCapacity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceCapacity =
      zio.aws.ec2.model.InstanceCapacity(
        availableCapacity.map(value => value),
        instanceType.map(value => value),
        totalCapacity.map(value => value)
      )
    def availableCapacity: Option[Integer]
    def instanceType: Option[String]
    def totalCapacity: Option[Integer]
    def getAvailableCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("availableCapacity", availableCapacity)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getTotalCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalCapacity", totalCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceCapacity
  ) extends zio.aws.ec2.model.InstanceCapacity.ReadOnly {
    override val availableCapacity: Option[Integer] =
      scala.Option(impl.availableCapacity()).map(value => value: Integer)
    override val instanceType: Option[String] =
      scala.Option(impl.instanceType()).map(value => value: String)
    override val totalCapacity: Option[Integer] =
      scala.Option(impl.totalCapacity()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceCapacity
  ): zio.aws.ec2.model.InstanceCapacity.ReadOnly = new Wrapper(impl)
}
