package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{MillisecondDateTime, DateTime, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Instance(
    amiLaunchIndex: Option[Integer] = None,
    imageId: Option[String] = None,
    instanceId: Option[String] = None,
    instanceType: Option[zio.aws.ec2.model.InstanceType] = None,
    kernelId: Option[String] = None,
    keyName: Option[String] = None,
    launchTime: Option[DateTime] = None,
    monitoring: Option[zio.aws.ec2.model.Monitoring] = None,
    placement: Option[zio.aws.ec2.model.Placement] = None,
    platform: Option[zio.aws.ec2.model.PlatformValues] = None,
    privateDnsName: Option[String] = None,
    privateIpAddress: Option[String] = None,
    productCodes: Option[Iterable[zio.aws.ec2.model.ProductCode]] = None,
    publicDnsName: Option[String] = None,
    publicIpAddress: Option[String] = None,
    ramdiskId: Option[String] = None,
    state: Option[zio.aws.ec2.model.InstanceState] = None,
    stateTransitionReason: Option[String] = None,
    subnetId: Option[String] = None,
    vpcId: Option[String] = None,
    architecture: Option[zio.aws.ec2.model.ArchitectureValues] = None,
    blockDeviceMappings: Option[
      Iterable[zio.aws.ec2.model.InstanceBlockDeviceMapping]
    ] = None,
    clientToken: Option[String] = None,
    ebsOptimized: Option[Boolean] = None,
    enaSupport: Option[Boolean] = None,
    hypervisor: Option[zio.aws.ec2.model.HypervisorType] = None,
    iamInstanceProfile: Option[zio.aws.ec2.model.IamInstanceProfile] = None,
    instanceLifecycle: Option[zio.aws.ec2.model.InstanceLifecycleType] = None,
    elasticGpuAssociations: Option[
      Iterable[zio.aws.ec2.model.ElasticGpuAssociation]
    ] = None,
    elasticInferenceAcceleratorAssociations: Option[
      Iterable[zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation]
    ] = None,
    networkInterfaces: Option[
      Iterable[zio.aws.ec2.model.InstanceNetworkInterface]
    ] = None,
    outpostArn: Option[String] = None,
    rootDeviceName: Option[String] = None,
    rootDeviceType: Option[zio.aws.ec2.model.DeviceType] = None,
    securityGroups: Option[Iterable[zio.aws.ec2.model.GroupIdentifier]] = None,
    sourceDestCheck: Option[Boolean] = None,
    spotInstanceRequestId: Option[String] = None,
    sriovNetSupport: Option[String] = None,
    stateReason: Option[zio.aws.ec2.model.StateReason] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    virtualizationType: Option[zio.aws.ec2.model.VirtualizationType] = None,
    cpuOptions: Option[zio.aws.ec2.model.CpuOptions] = None,
    capacityReservationId: Option[String] = None,
    capacityReservationSpecification: Option[
      zio.aws.ec2.model.CapacityReservationSpecificationResponse
    ] = None,
    hibernationOptions: Option[zio.aws.ec2.model.HibernationOptions] = None,
    licenses: Option[Iterable[zio.aws.ec2.model.LicenseConfiguration]] = None,
    metadataOptions: Option[zio.aws.ec2.model.InstanceMetadataOptionsResponse] =
      None,
    enclaveOptions: Option[zio.aws.ec2.model.EnclaveOptions] = None,
    bootMode: Option[zio.aws.ec2.model.BootModeValues] = None,
    platformDetails: Option[String] = None,
    usageOperation: Option[String] = None,
    usageOperationUpdateTime: Option[MillisecondDateTime] = None,
    privateDnsNameOptions: Option[
      zio.aws.ec2.model.PrivateDnsNameOptionsResponse
    ] = None,
    ipv6Address: Option[String] = None,
    maintenanceOptions: Option[zio.aws.ec2.model.InstanceMaintenanceOptions] =
      None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Instance = {
    import Instance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Instance
      .builder()
      .optionallyWith(amiLaunchIndex.map(value => value: java.lang.Integer))(
        _.amiLaunchIndex
      )
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(kernelId.map(value => value: java.lang.String))(
        _.kernelId
      )
      .optionallyWith(keyName.map(value => value: java.lang.String))(_.keyName)
      .optionallyWith(launchTime.map(value => DateTime.unwrap(value): Instant))(
        _.launchTime
      )
      .optionallyWith(monitoring.map(value => value.buildAwsValue()))(
        _.monitoring
      )
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(
        productCodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productCodes)
      .optionallyWith(publicDnsName.map(value => value: java.lang.String))(
        _.publicDnsName
      )
      .optionallyWith(publicIpAddress.map(value => value: java.lang.String))(
        _.publicIpAddress
      )
      .optionallyWith(ramdiskId.map(value => value: java.lang.String))(
        _.ramdiskId
      )
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(
        stateTransitionReason.map(value => value: java.lang.String)
      )(_.stateTransitionReason)
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(architecture.map(value => value.unwrap))(_.architecture)
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(enaSupport.map(value => value: java.lang.Boolean))(
        _.enaSupport
      )
      .optionallyWith(hypervisor.map(value => value.unwrap))(_.hypervisor)
      .optionallyWith(iamInstanceProfile.map(value => value.buildAwsValue()))(
        _.iamInstanceProfile
      )
      .optionallyWith(instanceLifecycle.map(value => value.unwrap))(
        _.instanceLifecycle
      )
      .optionallyWith(
        elasticGpuAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elasticGpuAssociations)
      .optionallyWith(
        elasticInferenceAcceleratorAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elasticInferenceAcceleratorAssociations)
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(rootDeviceName.map(value => value: java.lang.String))(
        _.rootDeviceName
      )
      .optionallyWith(rootDeviceType.map(value => value.unwrap))(
        _.rootDeviceType
      )
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(sourceDestCheck.map(value => value: java.lang.Boolean))(
        _.sourceDestCheck
      )
      .optionallyWith(
        spotInstanceRequestId.map(value => value: java.lang.String)
      )(_.spotInstanceRequestId)
      .optionallyWith(sriovNetSupport.map(value => value: java.lang.String))(
        _.sriovNetSupport
      )
      .optionallyWith(stateReason.map(value => value.buildAwsValue()))(
        _.stateReason
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(virtualizationType.map(value => value.unwrap))(
        _.virtualizationType
      )
      .optionallyWith(cpuOptions.map(value => value.buildAwsValue()))(
        _.cpuOptions
      )
      .optionallyWith(
        capacityReservationId.map(value => value: java.lang.String)
      )(_.capacityReservationId)
      .optionallyWith(
        capacityReservationSpecification.map(value => value.buildAwsValue())
      )(_.capacityReservationSpecification)
      .optionallyWith(hibernationOptions.map(value => value.buildAwsValue()))(
        _.hibernationOptions
      )
      .optionallyWith(
        licenses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenses)
      .optionallyWith(metadataOptions.map(value => value.buildAwsValue()))(
        _.metadataOptions
      )
      .optionallyWith(enclaveOptions.map(value => value.buildAwsValue()))(
        _.enclaveOptions
      )
      .optionallyWith(bootMode.map(value => value.unwrap))(_.bootMode)
      .optionallyWith(platformDetails.map(value => value: java.lang.String))(
        _.platformDetails
      )
      .optionallyWith(usageOperation.map(value => value: java.lang.String))(
        _.usageOperation
      )
      .optionallyWith(
        usageOperationUpdateTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.usageOperationUpdateTime)
      .optionallyWith(
        privateDnsNameOptions.map(value => value.buildAwsValue())
      )(_.privateDnsNameOptions)
      .optionallyWith(ipv6Address.map(value => value: java.lang.String))(
        _.ipv6Address
      )
      .optionallyWith(maintenanceOptions.map(value => value.buildAwsValue()))(
        _.maintenanceOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Instance.ReadOnly =
    zio.aws.ec2.model.Instance.wrap(buildAwsValue())
}
object Instance {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Instance] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Instance = zio.aws.ec2.model.Instance(
      amiLaunchIndex.map(value => value),
      imageId.map(value => value),
      instanceId.map(value => value),
      instanceType.map(value => value),
      kernelId.map(value => value),
      keyName.map(value => value),
      launchTime.map(value => value),
      monitoring.map(value => value.asEditable),
      placement.map(value => value.asEditable),
      platform.map(value => value),
      privateDnsName.map(value => value),
      privateIpAddress.map(value => value),
      productCodes.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      publicDnsName.map(value => value),
      publicIpAddress.map(value => value),
      ramdiskId.map(value => value),
      state.map(value => value.asEditable),
      stateTransitionReason.map(value => value),
      subnetId.map(value => value),
      vpcId.map(value => value),
      architecture.map(value => value),
      blockDeviceMappings.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      clientToken.map(value => value),
      ebsOptimized.map(value => value),
      enaSupport.map(value => value),
      hypervisor.map(value => value),
      iamInstanceProfile.map(value => value.asEditable),
      instanceLifecycle.map(value => value),
      elasticGpuAssociations.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      elasticInferenceAcceleratorAssociations.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      networkInterfaces.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      outpostArn.map(value => value),
      rootDeviceName.map(value => value),
      rootDeviceType.map(value => value),
      securityGroups.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      sourceDestCheck.map(value => value),
      spotInstanceRequestId.map(value => value),
      sriovNetSupport.map(value => value),
      stateReason.map(value => value.asEditable),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      virtualizationType.map(value => value),
      cpuOptions.map(value => value.asEditable),
      capacityReservationId.map(value => value),
      capacityReservationSpecification.map(value => value.asEditable),
      hibernationOptions.map(value => value.asEditable),
      licenses.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      metadataOptions.map(value => value.asEditable),
      enclaveOptions.map(value => value.asEditable),
      bootMode.map(value => value),
      platformDetails.map(value => value),
      usageOperation.map(value => value),
      usageOperationUpdateTime.map(value => value),
      privateDnsNameOptions.map(value => value.asEditable),
      ipv6Address.map(value => value),
      maintenanceOptions.map(value => value.asEditable)
    )
    def amiLaunchIndex: Option[Integer]
    def imageId: Option[String]
    def instanceId: Option[String]
    def instanceType: Option[zio.aws.ec2.model.InstanceType]
    def kernelId: Option[String]
    def keyName: Option[String]
    def launchTime: Option[DateTime]
    def monitoring: Option[zio.aws.ec2.model.Monitoring.ReadOnly]
    def placement: Option[zio.aws.ec2.model.Placement.ReadOnly]
    def platform: Option[zio.aws.ec2.model.PlatformValues]
    def privateDnsName: Option[String]
    def privateIpAddress: Option[String]
    def productCodes: Option[List[zio.aws.ec2.model.ProductCode.ReadOnly]]
    def publicDnsName: Option[String]
    def publicIpAddress: Option[String]
    def ramdiskId: Option[String]
    def state: Option[zio.aws.ec2.model.InstanceState.ReadOnly]
    def stateTransitionReason: Option[String]
    def subnetId: Option[String]
    def vpcId: Option[String]
    def architecture: Option[zio.aws.ec2.model.ArchitectureValues]
    def blockDeviceMappings
        : Option[List[zio.aws.ec2.model.InstanceBlockDeviceMapping.ReadOnly]]
    def clientToken: Option[String]
    def ebsOptimized: Option[Boolean]
    def enaSupport: Option[Boolean]
    def hypervisor: Option[zio.aws.ec2.model.HypervisorType]
    def iamInstanceProfile
        : Option[zio.aws.ec2.model.IamInstanceProfile.ReadOnly]
    def instanceLifecycle: Option[zio.aws.ec2.model.InstanceLifecycleType]
    def elasticGpuAssociations
        : Option[List[zio.aws.ec2.model.ElasticGpuAssociation.ReadOnly]]
    def elasticInferenceAcceleratorAssociations: Option[
      List[zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation.ReadOnly]
    ]
    def networkInterfaces
        : Option[List[zio.aws.ec2.model.InstanceNetworkInterface.ReadOnly]]
    def outpostArn: Option[String]
    def rootDeviceName: Option[String]
    def rootDeviceType: Option[zio.aws.ec2.model.DeviceType]
    def securityGroups: Option[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]]
    def sourceDestCheck: Option[Boolean]
    def spotInstanceRequestId: Option[String]
    def sriovNetSupport: Option[String]
    def stateReason: Option[zio.aws.ec2.model.StateReason.ReadOnly]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def virtualizationType: Option[zio.aws.ec2.model.VirtualizationType]
    def cpuOptions: Option[zio.aws.ec2.model.CpuOptions.ReadOnly]
    def capacityReservationId: Option[String]
    def capacityReservationSpecification: Option[
      zio.aws.ec2.model.CapacityReservationSpecificationResponse.ReadOnly
    ]
    def hibernationOptions
        : Option[zio.aws.ec2.model.HibernationOptions.ReadOnly]
    def licenses: Option[List[zio.aws.ec2.model.LicenseConfiguration.ReadOnly]]
    def metadataOptions
        : Option[zio.aws.ec2.model.InstanceMetadataOptionsResponse.ReadOnly]
    def enclaveOptions: Option[zio.aws.ec2.model.EnclaveOptions.ReadOnly]
    def bootMode: Option[zio.aws.ec2.model.BootModeValues]
    def platformDetails: Option[String]
    def usageOperation: Option[String]
    def usageOperationUpdateTime: Option[MillisecondDateTime]
    def privateDnsNameOptions
        : Option[zio.aws.ec2.model.PrivateDnsNameOptionsResponse.ReadOnly]
    def ipv6Address: Option[String]
    def maintenanceOptions
        : Option[zio.aws.ec2.model.InstanceMaintenanceOptions.ReadOnly]
    def getAmiLaunchIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("amiLaunchIndex", amiLaunchIndex)
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKernelId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getKeyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getLaunchTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("launchTime", launchTime)
    def getMonitoring
        : ZIO[Any, AwsError, zio.aws.ec2.model.Monitoring.ReadOnly] =
      AwsError.unwrapOptionField("monitoring", monitoring)
    def getPlacement: ZIO[Any, AwsError, zio.aws.ec2.model.Placement.ReadOnly] =
      AwsError.unwrapOptionField("placement", placement)
    def getPlatform: ZIO[Any, AwsError, zio.aws.ec2.model.PlatformValues] =
      AwsError.unwrapOptionField("platform", platform)
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getProductCodes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ProductCode.ReadOnly]] =
      AwsError.unwrapOptionField("productCodes", productCodes)
    def getPublicDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicDnsName", publicDnsName)
    def getPublicIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIpAddress", publicIpAddress)
    def getRamdiskId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceState.ReadOnly] =
      AwsError.unwrapOptionField("state", state)
    def getStateTransitionReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stateTransitionReason", stateTransitionReason)
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getArchitecture
        : ZIO[Any, AwsError, zio.aws.ec2.model.ArchitectureValues] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceBlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getEnaSupport: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enaSupport", enaSupport)
    def getHypervisor: ZIO[Any, AwsError, zio.aws.ec2.model.HypervisorType] =
      AwsError.unwrapOptionField("hypervisor", hypervisor)
    def getIamInstanceProfile
        : ZIO[Any, AwsError, zio.aws.ec2.model.IamInstanceProfile.ReadOnly] =
      AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getInstanceLifecycle
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceLifecycleType] =
      AwsError.unwrapOptionField("instanceLifecycle", instanceLifecycle)
    def getElasticGpuAssociations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ElasticGpuAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "elasticGpuAssociations",
      elasticGpuAssociations
    )
    def getElasticInferenceAcceleratorAssociations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "elasticInferenceAcceleratorAssociations",
      elasticInferenceAcceleratorAssociations
    )
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceNetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getRootDeviceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rootDeviceName", rootDeviceName)
    def getRootDeviceType: ZIO[Any, AwsError, zio.aws.ec2.model.DeviceType] =
      AwsError.unwrapOptionField("rootDeviceType", rootDeviceType)
    def getSecurityGroups
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSourceDestCheck: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("sourceDestCheck", sourceDestCheck)
    def getSpotInstanceRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotInstanceRequestId", spotInstanceRequestId)
    def getSriovNetSupport: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sriovNetSupport", sriovNetSupport)
    def getStateReason
        : ZIO[Any, AwsError, zio.aws.ec2.model.StateReason.ReadOnly] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVirtualizationType
        : ZIO[Any, AwsError, zio.aws.ec2.model.VirtualizationType] =
      AwsError.unwrapOptionField("virtualizationType", virtualizationType)
    def getCpuOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.CpuOptions.ReadOnly] =
      AwsError.unwrapOptionField("cpuOptions", cpuOptions)
    def getCapacityReservationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("capacityReservationId", capacityReservationId)
    def getCapacityReservationSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CapacityReservationSpecificationResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "capacityReservationSpecification",
      capacityReservationSpecification
    )
    def getHibernationOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.HibernationOptions.ReadOnly] =
      AwsError.unwrapOptionField("hibernationOptions", hibernationOptions)
    def getLicenses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LicenseConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("licenses", licenses)
    def getMetadataOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceMetadataOptionsResponse.ReadOnly
    ] = AwsError.unwrapOptionField("metadataOptions", metadataOptions)
    def getEnclaveOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.EnclaveOptions.ReadOnly] =
      AwsError.unwrapOptionField("enclaveOptions", enclaveOptions)
    def getBootMode: ZIO[Any, AwsError, zio.aws.ec2.model.BootModeValues] =
      AwsError.unwrapOptionField("bootMode", bootMode)
    def getPlatformDetails: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformDetails", platformDetails)
    def getUsageOperation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usageOperation", usageOperation)
    def getUsageOperationUpdateTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField(
        "usageOperationUpdateTime",
        usageOperationUpdateTime
      )
    def getPrivateDnsNameOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.PrivateDnsNameOptionsResponse.ReadOnly
    ] =
      AwsError.unwrapOptionField("privateDnsNameOptions", privateDnsNameOptions)
    def getIpv6Address: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6Address", ipv6Address)
    def getMaintenanceOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceMaintenanceOptions.ReadOnly
    ] = AwsError.unwrapOptionField("maintenanceOptions", maintenanceOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Instance
  ) extends zio.aws.ec2.model.Instance.ReadOnly {
    override val amiLaunchIndex: Option[Integer] =
      scala.Option(impl.amiLaunchIndex()).map(value => value: Integer)
    override val imageId: Option[String] =
      scala.Option(impl.imageId()).map(value => value: String)
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
    override val instanceType: Option[zio.aws.ec2.model.InstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val kernelId: Option[String] =
      scala.Option(impl.kernelId()).map(value => value: String)
    override val keyName: Option[String] =
      scala.Option(impl.keyName()).map(value => value: String)
    override val launchTime: Option[DateTime] = scala
      .Option(impl.launchTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val monitoring: Option[zio.aws.ec2.model.Monitoring.ReadOnly] =
      scala
        .Option(impl.monitoring())
        .map(value => zio.aws.ec2.model.Monitoring.wrap(value))
    override val placement: Option[zio.aws.ec2.model.Placement.ReadOnly] = scala
      .Option(impl.placement())
      .map(value => zio.aws.ec2.model.Placement.wrap(value))
    override val platform: Option[zio.aws.ec2.model.PlatformValues] = scala
      .Option(impl.platform())
      .map(value => zio.aws.ec2.model.PlatformValues.wrap(value))
    override val privateDnsName: Option[String] =
      scala.Option(impl.privateDnsName()).map(value => value: String)
    override val privateIpAddress: Option[String] =
      scala.Option(impl.privateIpAddress()).map(value => value: String)
    override val productCodes
        : Option[List[zio.aws.ec2.model.ProductCode.ReadOnly]] = scala
      .Option(impl.productCodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ProductCode.wrap(item)
        }.toList
      )
    override val publicDnsName: Option[String] =
      scala.Option(impl.publicDnsName()).map(value => value: String)
    override val publicIpAddress: Option[String] =
      scala.Option(impl.publicIpAddress()).map(value => value: String)
    override val ramdiskId: Option[String] =
      scala.Option(impl.ramdiskId()).map(value => value: String)
    override val state: Option[zio.aws.ec2.model.InstanceState.ReadOnly] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.InstanceState.wrap(value))
    override val stateTransitionReason: Option[String] =
      scala.Option(impl.stateTransitionReason()).map(value => value: String)
    override val subnetId: Option[String] =
      scala.Option(impl.subnetId()).map(value => value: String)
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val architecture: Option[zio.aws.ec2.model.ArchitectureValues] =
      scala
        .Option(impl.architecture())
        .map(value => zio.aws.ec2.model.ArchitectureValues.wrap(value))
    override val blockDeviceMappings
        : Option[List[zio.aws.ec2.model.InstanceBlockDeviceMapping.ReadOnly]] =
      scala
        .Option(impl.blockDeviceMappings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceBlockDeviceMapping.wrap(item)
          }.toList
        )
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val ebsOptimized: Option[Boolean] =
      scala.Option(impl.ebsOptimized()).map(value => value: Boolean)
    override val enaSupport: Option[Boolean] =
      scala.Option(impl.enaSupport()).map(value => value: Boolean)
    override val hypervisor: Option[zio.aws.ec2.model.HypervisorType] = scala
      .Option(impl.hypervisor())
      .map(value => zio.aws.ec2.model.HypervisorType.wrap(value))
    override val iamInstanceProfile
        : Option[zio.aws.ec2.model.IamInstanceProfile.ReadOnly] = scala
      .Option(impl.iamInstanceProfile())
      .map(value => zio.aws.ec2.model.IamInstanceProfile.wrap(value))
    override val instanceLifecycle
        : Option[zio.aws.ec2.model.InstanceLifecycleType] = scala
      .Option(impl.instanceLifecycle())
      .map(value => zio.aws.ec2.model.InstanceLifecycleType.wrap(value))
    override val elasticGpuAssociations
        : Option[List[zio.aws.ec2.model.ElasticGpuAssociation.ReadOnly]] = scala
      .Option(impl.elasticGpuAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ElasticGpuAssociation.wrap(item)
        }.toList
      )
    override val elasticInferenceAcceleratorAssociations: Option[
      List[zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation.ReadOnly]
    ] = scala
      .Option(impl.elasticInferenceAcceleratorAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation.wrap(item)
        }.toList
      )
    override val networkInterfaces
        : Option[List[zio.aws.ec2.model.InstanceNetworkInterface.ReadOnly]] =
      scala
        .Option(impl.networkInterfaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceNetworkInterface.wrap(item)
          }.toList
        )
    override val outpostArn: Option[String] =
      scala.Option(impl.outpostArn()).map(value => value: String)
    override val rootDeviceName: Option[String] =
      scala.Option(impl.rootDeviceName()).map(value => value: String)
    override val rootDeviceType: Option[zio.aws.ec2.model.DeviceType] = scala
      .Option(impl.rootDeviceType())
      .map(value => zio.aws.ec2.model.DeviceType.wrap(value))
    override val securityGroups
        : Option[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.GroupIdentifier.wrap(item)
        }.toList
      )
    override val sourceDestCheck: Option[Boolean] =
      scala.Option(impl.sourceDestCheck()).map(value => value: Boolean)
    override val spotInstanceRequestId: Option[String] =
      scala.Option(impl.spotInstanceRequestId()).map(value => value: String)
    override val sriovNetSupport: Option[String] =
      scala.Option(impl.sriovNetSupport()).map(value => value: String)
    override val stateReason: Option[zio.aws.ec2.model.StateReason.ReadOnly] =
      scala
        .Option(impl.stateReason())
        .map(value => zio.aws.ec2.model.StateReason.wrap(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val virtualizationType
        : Option[zio.aws.ec2.model.VirtualizationType] = scala
      .Option(impl.virtualizationType())
      .map(value => zio.aws.ec2.model.VirtualizationType.wrap(value))
    override val cpuOptions: Option[zio.aws.ec2.model.CpuOptions.ReadOnly] =
      scala
        .Option(impl.cpuOptions())
        .map(value => zio.aws.ec2.model.CpuOptions.wrap(value))
    override val capacityReservationId: Option[String] =
      scala.Option(impl.capacityReservationId()).map(value => value: String)
    override val capacityReservationSpecification: Option[
      zio.aws.ec2.model.CapacityReservationSpecificationResponse.ReadOnly
    ] = scala
      .Option(impl.capacityReservationSpecification())
      .map(value =>
        zio.aws.ec2.model.CapacityReservationSpecificationResponse.wrap(value)
      )
    override val hibernationOptions
        : Option[zio.aws.ec2.model.HibernationOptions.ReadOnly] = scala
      .Option(impl.hibernationOptions())
      .map(value => zio.aws.ec2.model.HibernationOptions.wrap(value))
    override val licenses
        : Option[List[zio.aws.ec2.model.LicenseConfiguration.ReadOnly]] = scala
      .Option(impl.licenses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LicenseConfiguration.wrap(item)
        }.toList
      )
    override val metadataOptions
        : Option[zio.aws.ec2.model.InstanceMetadataOptionsResponse.ReadOnly] =
      scala
        .Option(impl.metadataOptions())
        .map(value =>
          zio.aws.ec2.model.InstanceMetadataOptionsResponse.wrap(value)
        )
    override val enclaveOptions
        : Option[zio.aws.ec2.model.EnclaveOptions.ReadOnly] = scala
      .Option(impl.enclaveOptions())
      .map(value => zio.aws.ec2.model.EnclaveOptions.wrap(value))
    override val bootMode: Option[zio.aws.ec2.model.BootModeValues] = scala
      .Option(impl.bootMode())
      .map(value => zio.aws.ec2.model.BootModeValues.wrap(value))
    override val platformDetails: Option[String] =
      scala.Option(impl.platformDetails()).map(value => value: String)
    override val usageOperation: Option[String] =
      scala.Option(impl.usageOperation()).map(value => value: String)
    override val usageOperationUpdateTime: Option[MillisecondDateTime] = scala
      .Option(impl.usageOperationUpdateTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val privateDnsNameOptions
        : Option[zio.aws.ec2.model.PrivateDnsNameOptionsResponse.ReadOnly] =
      scala
        .Option(impl.privateDnsNameOptions())
        .map(value =>
          zio.aws.ec2.model.PrivateDnsNameOptionsResponse.wrap(value)
        )
    override val ipv6Address: Option[String] =
      scala.Option(impl.ipv6Address()).map(value => value: String)
    override val maintenanceOptions
        : Option[zio.aws.ec2.model.InstanceMaintenanceOptions.ReadOnly] = scala
      .Option(impl.maintenanceOptions())
      .map(value => zio.aws.ec2.model.InstanceMaintenanceOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Instance
  ): zio.aws.ec2.model.Instance.ReadOnly = new Wrapper(impl)
}
