package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  InferenceDeviceManufacturerName,
  InferenceDeviceName,
  InferenceDeviceCount
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InferenceDeviceInfo(
    count: Option[InferenceDeviceCount] = None,
    name: Option[InferenceDeviceName] = None,
    manufacturer: Option[InferenceDeviceManufacturerName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InferenceDeviceInfo = {
    import InferenceDeviceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InferenceDeviceInfo
      .builder()
      .optionallyWith(
        count.map(value => InferenceDeviceCount.unwrap(value): Integer)
      )(_.count)
      .optionallyWith(
        name.map(value => InferenceDeviceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        manufacturer.map(value =>
          InferenceDeviceManufacturerName.unwrap(value): java.lang.String
        )
      )(_.manufacturer)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InferenceDeviceInfo.ReadOnly =
    zio.aws.ec2.model.InferenceDeviceInfo.wrap(buildAwsValue())
}
object InferenceDeviceInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InferenceDeviceInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InferenceDeviceInfo =
      zio.aws.ec2.model.InferenceDeviceInfo(
        count.map(value => value),
        name.map(value => value),
        manufacturer.map(value => value)
      )
    def count: Option[InferenceDeviceCount]
    def name: Option[InferenceDeviceName]
    def manufacturer: Option[InferenceDeviceManufacturerName]
    def getCount: ZIO[Any, AwsError, InferenceDeviceCount] =
      AwsError.unwrapOptionField("count", count)
    def getName: ZIO[Any, AwsError, InferenceDeviceName] =
      AwsError.unwrapOptionField("name", name)
    def getManufacturer: ZIO[Any, AwsError, InferenceDeviceManufacturerName] =
      AwsError.unwrapOptionField("manufacturer", manufacturer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InferenceDeviceInfo
  ) extends zio.aws.ec2.model.InferenceDeviceInfo.ReadOnly {
    override val count: Option[InferenceDeviceCount] = scala
      .Option(impl.count())
      .map(value => zio.aws.ec2.model.primitives.InferenceDeviceCount(value))
    override val name: Option[InferenceDeviceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ec2.model.primitives.InferenceDeviceName(value))
    override val manufacturer: Option[InferenceDeviceManufacturerName] = scala
      .Option(impl.manufacturer())
      .map(value =>
        zio.aws.ec2.model.primitives.InferenceDeviceManufacturerName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InferenceDeviceInfo
  ): zio.aws.ec2.model.InferenceDeviceInfo.ReadOnly = new Wrapper(impl)
}
