package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  SpotPlacementScoresMaxResults,
  SpotPlacementScoresTargetCapacity
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetSpotPlacementScoresRequest(
    instanceTypes: Option[Iterable[String]] = None,
    targetCapacity: SpotPlacementScoresTargetCapacity,
    targetCapacityUnitType: Option[zio.aws.ec2.model.TargetCapacityUnitType] =
      None,
    singleAvailabilityZone: Option[Boolean] = None,
    regionNames: Option[Iterable[String]] = None,
    instanceRequirementsWithMetadata: Option[
      zio.aws.ec2.model.InstanceRequirementsWithMetadataRequest
    ] = None,
    maxResults: Option[SpotPlacementScoresMaxResults] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresRequest = {
    import GetSpotPlacementScoresRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresRequest
      .builder()
      .optionallyWith(
        instanceTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.instanceTypes)
      .targetCapacity(
        SpotPlacementScoresTargetCapacity.unwrap(targetCapacity): Integer
      )
      .optionallyWith(targetCapacityUnitType.map(value => value.unwrap))(
        _.targetCapacityUnitType
      )
      .optionallyWith(
        singleAvailabilityZone.map(value => value: java.lang.Boolean)
      )(_.singleAvailabilityZone)
      .optionallyWith(
        regionNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.regionNames)
      .optionallyWith(
        instanceRequirementsWithMetadata.map(value => value.buildAwsValue())
      )(_.instanceRequirementsWithMetadata)
      .optionallyWith(
        maxResults.map(value =>
          SpotPlacementScoresMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetSpotPlacementScoresRequest.ReadOnly =
    zio.aws.ec2.model.GetSpotPlacementScoresRequest.wrap(buildAwsValue())
}
object GetSpotPlacementScoresRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetSpotPlacementScoresRequest =
      zio.aws.ec2.model.GetSpotPlacementScoresRequest(
        instanceTypes.map(value => value),
        targetCapacity,
        targetCapacityUnitType.map(value => value),
        singleAvailabilityZone.map(value => value),
        regionNames.map(value => value),
        instanceRequirementsWithMetadata.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def instanceTypes: Option[List[String]]
    def targetCapacity: SpotPlacementScoresTargetCapacity
    def targetCapacityUnitType: Option[zio.aws.ec2.model.TargetCapacityUnitType]
    def singleAvailabilityZone: Option[Boolean]
    def regionNames: Option[List[String]]
    def instanceRequirementsWithMetadata: Option[
      zio.aws.ec2.model.InstanceRequirementsWithMetadataRequest.ReadOnly
    ]
    def maxResults: Option[SpotPlacementScoresMaxResults]
    def nextToken: Option[String]
    def getInstanceTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("instanceTypes", instanceTypes)
    def getTargetCapacity
        : ZIO[Any, Nothing, SpotPlacementScoresTargetCapacity] =
      ZIO.succeed(targetCapacity)
    def getTargetCapacityUnitType
        : ZIO[Any, AwsError, zio.aws.ec2.model.TargetCapacityUnitType] =
      AwsError.unwrapOptionField(
        "targetCapacityUnitType",
        targetCapacityUnitType
      )
    def getSingleAvailabilityZone: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("singleAvailabilityZone", singleAvailabilityZone)
    def getRegionNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("regionNames", regionNames)
    def getInstanceRequirementsWithMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceRequirementsWithMetadataRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "instanceRequirementsWithMetadata",
      instanceRequirementsWithMetadata
    )
    def getMaxResults: ZIO[Any, AwsError, SpotPlacementScoresMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresRequest
  ) extends zio.aws.ec2.model.GetSpotPlacementScoresRequest.ReadOnly {
    override val instanceTypes: Option[List[String]] = scala
      .Option(impl.instanceTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val targetCapacity: SpotPlacementScoresTargetCapacity =
      zio.aws.ec2.model.primitives
        .SpotPlacementScoresTargetCapacity(impl.targetCapacity())
    override val targetCapacityUnitType
        : Option[zio.aws.ec2.model.TargetCapacityUnitType] = scala
      .Option(impl.targetCapacityUnitType())
      .map(value => zio.aws.ec2.model.TargetCapacityUnitType.wrap(value))
    override val singleAvailabilityZone: Option[Boolean] =
      scala.Option(impl.singleAvailabilityZone()).map(value => value: Boolean)
    override val regionNames: Option[List[String]] = scala
      .Option(impl.regionNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val instanceRequirementsWithMetadata: Option[
      zio.aws.ec2.model.InstanceRequirementsWithMetadataRequest.ReadOnly
    ] = scala
      .Option(impl.instanceRequirementsWithMetadata())
      .map(value =>
        zio.aws.ec2.model.InstanceRequirementsWithMetadataRequest.wrap(value)
      )
    override val maxResults: Option[SpotPlacementScoresMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.SpotPlacementScoresMaxResults(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresRequest
  ): zio.aws.ec2.model.GetSpotPlacementScoresRequest.ReadOnly = new Wrapper(
    impl
  )
}
