package zio.aws.ec2.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  IpamAddressHistoryMaxResults,
  MillisecondDateTime,
  IpamScopeId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetIpamAddressHistoryRequest(
    cidr: String,
    ipamScopeId: IpamScopeId,
    vpcId: Option[String] = None,
    startTime: Option[MillisecondDateTime] = None,
    endTime: Option[MillisecondDateTime] = None,
    maxResults: Option[IpamAddressHistoryMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryRequest = {
    import GetIpamAddressHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryRequest
      .builder()
      .cidr(cidr: java.lang.String)
      .ipamScopeId(IpamScopeId.unwrap(ipamScopeId): java.lang.String)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        startTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.endTime)
      .optionallyWith(
        maxResults.map(value =>
          IpamAddressHistoryMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetIpamAddressHistoryRequest.ReadOnly =
    zio.aws.ec2.model.GetIpamAddressHistoryRequest.wrap(buildAwsValue())
}
object GetIpamAddressHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetIpamAddressHistoryRequest =
      zio.aws.ec2.model.GetIpamAddressHistoryRequest(
        cidr,
        ipamScopeId,
        vpcId.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def cidr: String
    def ipamScopeId: IpamScopeId
    def vpcId: Option[String]
    def startTime: Option[MillisecondDateTime]
    def endTime: Option[MillisecondDateTime]
    def maxResults: Option[IpamAddressHistoryMaxResults]
    def nextToken: Option[NextToken]
    def getCidr: ZIO[Any, Nothing, String] = ZIO.succeed(cidr)
    def getIpamScopeId: ZIO[Any, Nothing, IpamScopeId] =
      ZIO.succeed(ipamScopeId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getStartTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getMaxResults: ZIO[Any, AwsError, IpamAddressHistoryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryRequest
  ) extends zio.aws.ec2.model.GetIpamAddressHistoryRequest.ReadOnly {
    override val cidr: String = impl.cidr(): String
    override val ipamScopeId: IpamScopeId =
      zio.aws.ec2.model.primitives.IpamScopeId(impl.ipamScopeId())
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val startTime: Option[MillisecondDateTime] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val endTime: Option[MillisecondDateTime] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val maxResults: Option[IpamAddressHistoryMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.IpamAddressHistoryMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryRequest
  ): zio.aws.ec2.model.GetIpamAddressHistoryRequest.ReadOnly = new Wrapper(impl)
}
