package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait FleetExcessCapacityTerminationPolicy {
  def unwrap: software.amazon.awssdk.services.ec2.model.FleetExcessCapacityTerminationPolicy
}
object FleetExcessCapacityTerminationPolicy {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.FleetExcessCapacityTerminationPolicy
  ): zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy = value match {
    case software.amazon.awssdk.services.ec2.model.FleetExcessCapacityTerminationPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.FleetExcessCapacityTerminationPolicy.NO_TERMINATION =>
      val r = `no-termination`
      r
    case software.amazon.awssdk.services.ec2.model.FleetExcessCapacityTerminationPolicy.TERMINATION =>
      val r = termination
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetExcessCapacityTerminationPolicy =
      software.amazon.awssdk.services.ec2.model.FleetExcessCapacityTerminationPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object `no-termination`
      extends zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetExcessCapacityTerminationPolicy =
      software.amazon.awssdk.services.ec2.model.FleetExcessCapacityTerminationPolicy.NO_TERMINATION
  }
  case object termination
      extends zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetExcessCapacityTerminationPolicy =
      software.amazon.awssdk.services.ec2.model.FleetExcessCapacityTerminationPolicy.TERMINATION
  }
}
