package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ResourceArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisassociateEnclaveCertificateIamRoleRequest(
    certificateArn: Option[ResourceArn] = None,
    roleArn: Option[ResourceArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleRequest = {
    import DisassociateEnclaveCertificateIamRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleRequest
      .builder()
      .optionallyWith(
        certificateArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.certificateArn)
      .optionallyWith(
        roleArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleRequest
      .wrap(buildAwsValue())
}
object DisassociateEnclaveCertificateIamRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleRequest =
      zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleRequest(
        certificateArn.map(value => value),
        roleArn.map(value => value)
      )
    def certificateArn: Option[ResourceArn]
    def roleArn: Option[ResourceArn]
    def getCertificateArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getRoleArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleRequest
  ) extends zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleRequest.ReadOnly {
    override val certificateArn: Option[ResourceArn] = scala
      .Option(impl.certificateArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val roleArn: Option[ResourceArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleRequest
  ): zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleRequest.ReadOnly =
    new Wrapper(impl)
}
