package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisableVpcClassicLinkRequest(vpcId: VpcId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkRequest = {
    import DisableVpcClassicLinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkRequest
      .builder()
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DisableVpcClassicLinkRequest.ReadOnly =
    zio.aws.ec2.model.DisableVpcClassicLinkRequest.wrap(buildAwsValue())
}
object DisableVpcClassicLinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisableVpcClassicLinkRequest =
      zio.aws.ec2.model.DisableVpcClassicLinkRequest(vpcId)
    def vpcId: VpcId
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkRequest
  ) extends zio.aws.ec2.model.DisableVpcClassicLinkRequest.ReadOnly {
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkRequest
  ): zio.aws.ec2.model.DisableVpcClassicLinkRequest.ReadOnly = new Wrapper(impl)
}
