package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DhcpOptions(
    dhcpConfigurations: Option[Iterable[zio.aws.ec2.model.DhcpConfiguration]] =
      None,
    dhcpOptionsId: Option[String] = None,
    ownerId: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.DhcpOptions = {
    import DhcpOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DhcpOptions
      .builder()
      .optionallyWith(
        dhcpConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dhcpConfigurations)
      .optionallyWith(dhcpOptionsId.map(value => value: java.lang.String))(
        _.dhcpOptionsId
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DhcpOptions.ReadOnly =
    zio.aws.ec2.model.DhcpOptions.wrap(buildAwsValue())
}
object DhcpOptions {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.DhcpOptions] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DhcpOptions =
      zio.aws.ec2.model.DhcpOptions(
        dhcpConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dhcpOptionsId.map(value => value),
        ownerId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dhcpConfigurations
        : Option[List[zio.aws.ec2.model.DhcpConfiguration.ReadOnly]]
    def dhcpOptionsId: Option[String]
    def ownerId: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getDhcpConfigurations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.DhcpConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("dhcpConfigurations", dhcpConfigurations)
    def getDhcpOptionsId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dhcpOptionsId", dhcpOptionsId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DhcpOptions
  ) extends zio.aws.ec2.model.DhcpOptions.ReadOnly {
    override val dhcpConfigurations
        : Option[List[zio.aws.ec2.model.DhcpConfiguration.ReadOnly]] = scala
      .Option(impl.dhcpConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.DhcpConfiguration.wrap(item)
        }.toList
      )
    override val dhcpOptionsId: Option[String] =
      scala.Option(impl.dhcpOptionsId()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DhcpOptions
  ): zio.aws.ec2.model.DhcpOptions.ReadOnly = new Wrapper(impl)
}
