package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DetachClassicLinkVpcResponse(
    returnValue: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcResponse = {
    import DetachClassicLinkVpcResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DetachClassicLinkVpcResponse.ReadOnly =
    zio.aws.ec2.model.DetachClassicLinkVpcResponse.wrap(buildAwsValue())
}
object DetachClassicLinkVpcResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DetachClassicLinkVpcResponse =
      zio.aws.ec2.model
        .DetachClassicLinkVpcResponse(returnValue.map(value => value))
    def returnValue: Option[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcResponse
  ) extends zio.aws.ec2.model.DetachClassicLinkVpcResponse.ReadOnly {
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcResponse
  ): zio.aws.ec2.model.DetachClassicLinkVpcResponse.ReadOnly = new Wrapper(impl)
}
