package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  NextToken,
  DescribeClientVpnEndpointMaxResults,
  ClientVpnEndpointId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeClientVpnEndpointsRequest(
    clientVpnEndpointIds: Option[Iterable[ClientVpnEndpointId]] = None,
    maxResults: Option[DescribeClientVpnEndpointMaxResults] = None,
    nextToken: Option[NextToken] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsRequest = {
    import DescribeClientVpnEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsRequest
      .builder()
      .optionallyWith(
        clientVpnEndpointIds.map(value =>
          value.map { item =>
            ClientVpnEndpointId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.clientVpnEndpointIds)
      .optionallyWith(
        maxResults.map(value =>
          DescribeClientVpnEndpointMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeClientVpnEndpointsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeClientVpnEndpointsRequest.wrap(buildAwsValue())
}
object DescribeClientVpnEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeClientVpnEndpointsRequest =
      zio.aws.ec2.model.DescribeClientVpnEndpointsRequest(
        clientVpnEndpointIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientVpnEndpointIds: Option[List[ClientVpnEndpointId]]
    def maxResults: Option[DescribeClientVpnEndpointMaxResults]
    def nextToken: Option[NextToken]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def getClientVpnEndpointIds: ZIO[Any, AwsError, List[ClientVpnEndpointId]] =
      AwsError.unwrapOptionField("clientVpnEndpointIds", clientVpnEndpointIds)
    def getMaxResults: ZIO[Any, AwsError, DescribeClientVpnEndpointMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsRequest
  ) extends zio.aws.ec2.model.DescribeClientVpnEndpointsRequest.ReadOnly {
    override val clientVpnEndpointIds: Option[List[ClientVpnEndpointId]] = scala
      .Option(impl.clientVpnEndpointIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.ClientVpnEndpointId(item)
        }.toList
      )
    override val maxResults: Option[DescribeClientVpnEndpointMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.DescribeClientVpnEndpointMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsRequest
  ): zio.aws.ec2.model.DescribeClientVpnEndpointsRequest.ReadOnly = new Wrapper(
    impl
  )
}
