package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  Integer,
  TrafficMirrorFilterId,
  TrafficMirrorTargetId,
  NetworkInterfaceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateTrafficMirrorSessionRequest(
    networkInterfaceId: NetworkInterfaceId,
    trafficMirrorTargetId: TrafficMirrorTargetId,
    trafficMirrorFilterId: TrafficMirrorFilterId,
    packetLength: Option[Integer] = None,
    sessionNumber: Integer,
    virtualNetworkId: Option[Integer] = None,
    description: Option[String] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None,
    clientToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionRequest = {
    import CreateTrafficMirrorSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionRequest
      .builder()
      .networkInterfaceId(
        NetworkInterfaceId.unwrap(networkInterfaceId): java.lang.String
      )
      .trafficMirrorTargetId(
        TrafficMirrorTargetId.unwrap(trafficMirrorTargetId): java.lang.String
      )
      .trafficMirrorFilterId(
        TrafficMirrorFilterId.unwrap(trafficMirrorFilterId): java.lang.String
      )
      .optionallyWith(packetLength.map(value => value: java.lang.Integer))(
        _.packetLength
      )
      .sessionNumber(sessionNumber: java.lang.Integer)
      .optionallyWith(virtualNetworkId.map(value => value: java.lang.Integer))(
        _.virtualNetworkId
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateTrafficMirrorSessionRequest.ReadOnly =
    zio.aws.ec2.model.CreateTrafficMirrorSessionRequest.wrap(buildAwsValue())
}
object CreateTrafficMirrorSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateTrafficMirrorSessionRequest =
      zio.aws.ec2.model.CreateTrafficMirrorSessionRequest(
        networkInterfaceId,
        trafficMirrorTargetId,
        trafficMirrorFilterId,
        packetLength.map(value => value),
        sessionNumber,
        virtualNetworkId.map(value => value),
        description.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def networkInterfaceId: NetworkInterfaceId
    def trafficMirrorTargetId: TrafficMirrorTargetId
    def trafficMirrorFilterId: TrafficMirrorFilterId
    def packetLength: Option[Integer]
    def sessionNumber: Integer
    def virtualNetworkId: Option[Integer]
    def description: Option[String]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def clientToken: Option[String]
    def getNetworkInterfaceId: ZIO[Any, Nothing, NetworkInterfaceId] =
      ZIO.succeed(networkInterfaceId)
    def getTrafficMirrorTargetId: ZIO[Any, Nothing, TrafficMirrorTargetId] =
      ZIO.succeed(trafficMirrorTargetId)
    def getTrafficMirrorFilterId: ZIO[Any, Nothing, TrafficMirrorFilterId] =
      ZIO.succeed(trafficMirrorFilterId)
    def getPacketLength: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("packetLength", packetLength)
    def getSessionNumber: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(sessionNumber)
    def getVirtualNetworkId: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("virtualNetworkId", virtualNetworkId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionRequest
  ) extends zio.aws.ec2.model.CreateTrafficMirrorSessionRequest.ReadOnly {
    override val networkInterfaceId: NetworkInterfaceId =
      zio.aws.ec2.model.primitives.NetworkInterfaceId(impl.networkInterfaceId())
    override val trafficMirrorTargetId: TrafficMirrorTargetId =
      zio.aws.ec2.model.primitives
        .TrafficMirrorTargetId(impl.trafficMirrorTargetId())
    override val trafficMirrorFilterId: TrafficMirrorFilterId =
      zio.aws.ec2.model.primitives
        .TrafficMirrorFilterId(impl.trafficMirrorFilterId())
    override val packetLength: Option[Integer] =
      scala.Option(impl.packetLength()).map(value => value: Integer)
    override val sessionNumber: Integer = impl.sessionNumber(): Integer
    override val virtualNetworkId: Option[Integer] =
      scala.Option(impl.virtualNetworkId()).map(value => value: Integer)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionRequest
  ): zio.aws.ec2.model.CreateTrafficMirrorSessionRequest.ReadOnly = new Wrapper(
    impl
  )
}
