package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpcId, LocalGatewayRoutetableId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateLocalGatewayRouteTableVpcAssociationRequest(
    localGatewayRouteTableId: LocalGatewayRoutetableId,
    vpcId: VpcId,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationRequest = {
    import CreateLocalGatewayRouteTableVpcAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationRequest
      .builder()
      .localGatewayRouteTableId(
        LocalGatewayRoutetableId.unwrap(
          localGatewayRouteTableId
        ): java.lang.String
      )
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationRequest.ReadOnly =
    zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationRequest
      .wrap(buildAwsValue())
}
object CreateLocalGatewayRouteTableVpcAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationRequest =
      zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationRequest(
        localGatewayRouteTableId,
        vpcId,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def localGatewayRouteTableId: LocalGatewayRoutetableId
    def vpcId: VpcId
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getLocalGatewayRouteTableId
        : ZIO[Any, Nothing, LocalGatewayRoutetableId] =
      ZIO.succeed(localGatewayRouteTableId)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationRequest
  ) extends zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationRequest.ReadOnly {
    override val localGatewayRouteTableId: LocalGatewayRoutetableId =
      zio.aws.ec2.model.primitives
        .LocalGatewayRoutetableId(impl.localGatewayRouteTableId())
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationRequest
  ): zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
