package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpAddress
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AnalysisPacketHeader(
    destinationAddresses: Option[Iterable[IpAddress]] = None,
    destinationPortRanges: Option[Iterable[zio.aws.ec2.model.PortRange]] = None,
    protocol: Option[String] = None,
    sourceAddresses: Option[Iterable[IpAddress]] = None,
    sourcePortRanges: Option[Iterable[zio.aws.ec2.model.PortRange]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AnalysisPacketHeader = {
    import AnalysisPacketHeader.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AnalysisPacketHeader
      .builder()
      .optionallyWith(
        destinationAddresses.map(value =>
          value.map { item =>
            IpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.destinationAddresses)
      .optionallyWith(
        destinationPortRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinationPortRanges)
      .optionallyWith(protocol.map(value => value: java.lang.String))(
        _.protocol
      )
      .optionallyWith(
        sourceAddresses.map(value =>
          value.map { item =>
            IpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sourceAddresses)
      .optionallyWith(
        sourcePortRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourcePortRanges)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AnalysisPacketHeader.ReadOnly =
    zio.aws.ec2.model.AnalysisPacketHeader.wrap(buildAwsValue())
}
object AnalysisPacketHeader {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AnalysisPacketHeader
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AnalysisPacketHeader =
      zio.aws.ec2.model.AnalysisPacketHeader(
        destinationAddresses.map(value => value),
        destinationPortRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        protocol.map(value => value),
        sourceAddresses.map(value => value),
        sourcePortRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def destinationAddresses: Option[List[IpAddress]]
    def destinationPortRanges
        : Option[List[zio.aws.ec2.model.PortRange.ReadOnly]]
    def protocol: Option[String]
    def sourceAddresses: Option[List[IpAddress]]
    def sourcePortRanges: Option[List[zio.aws.ec2.model.PortRange.ReadOnly]]
    def getDestinationAddresses: ZIO[Any, AwsError, List[IpAddress]] =
      AwsError.unwrapOptionField("destinationAddresses", destinationAddresses)
    def getDestinationPortRanges
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PortRange.ReadOnly]] =
      AwsError.unwrapOptionField("destinationPortRanges", destinationPortRanges)
    def getProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getSourceAddresses: ZIO[Any, AwsError, List[IpAddress]] =
      AwsError.unwrapOptionField("sourceAddresses", sourceAddresses)
    def getSourcePortRanges
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PortRange.ReadOnly]] =
      AwsError.unwrapOptionField("sourcePortRanges", sourcePortRanges)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AnalysisPacketHeader
  ) extends zio.aws.ec2.model.AnalysisPacketHeader.ReadOnly {
    override val destinationAddresses: Option[List[IpAddress]] = scala
      .Option(impl.destinationAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.IpAddress(item)
        }.toList
      )
    override val destinationPortRanges
        : Option[List[zio.aws.ec2.model.PortRange.ReadOnly]] = scala
      .Option(impl.destinationPortRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.PortRange.wrap(item)
        }.toList
      )
    override val protocol: Option[String] =
      scala.Option(impl.protocol()).map(value => value: String)
    override val sourceAddresses: Option[List[IpAddress]] = scala
      .Option(impl.sourceAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.IpAddress(item)
        }.toList
      )
    override val sourcePortRanges
        : Option[List[zio.aws.ec2.model.PortRange.ReadOnly]] = scala
      .Option(impl.sourcePortRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.PortRange.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AnalysisPacketHeader
  ): zio.aws.ec2.model.AnalysisPacketHeader.ReadOnly = new Wrapper(impl)
}
