package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AccessScopePathRequest(
    source: Option[zio.aws.ec2.model.PathStatementRequest] = None,
    destination: Option[zio.aws.ec2.model.PathStatementRequest] = None,
    throughResources: Option[
      Iterable[zio.aws.ec2.model.ThroughResourcesStatementRequest]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AccessScopePathRequest = {
    import AccessScopePathRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AccessScopePathRequest
      .builder()
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(
        throughResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.throughResources)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AccessScopePathRequest.ReadOnly =
    zio.aws.ec2.model.AccessScopePathRequest.wrap(buildAwsValue())
}
object AccessScopePathRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AccessScopePathRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AccessScopePathRequest =
      zio.aws.ec2.model.AccessScopePathRequest(
        source.map(value => value.asEditable),
        destination.map(value => value.asEditable),
        throughResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def source: Option[zio.aws.ec2.model.PathStatementRequest.ReadOnly]
    def destination: Option[zio.aws.ec2.model.PathStatementRequest.ReadOnly]
    def throughResources: Option[
      List[zio.aws.ec2.model.ThroughResourcesStatementRequest.ReadOnly]
    ]
    def getSource
        : ZIO[Any, AwsError, zio.aws.ec2.model.PathStatementRequest.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getDestination
        : ZIO[Any, AwsError, zio.aws.ec2.model.PathStatementRequest.ReadOnly] =
      AwsError.unwrapOptionField("destination", destination)
    def getThroughResources: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ThroughResourcesStatementRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("throughResources", throughResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AccessScopePathRequest
  ) extends zio.aws.ec2.model.AccessScopePathRequest.ReadOnly {
    override val source
        : Option[zio.aws.ec2.model.PathStatementRequest.ReadOnly] = scala
      .Option(impl.source())
      .map(value => zio.aws.ec2.model.PathStatementRequest.wrap(value))
    override val destination
        : Option[zio.aws.ec2.model.PathStatementRequest.ReadOnly] = scala
      .Option(impl.destination())
      .map(value => zio.aws.ec2.model.PathStatementRequest.wrap(value))
    override val throughResources: Option[
      List[zio.aws.ec2.model.ThroughResourcesStatementRequest.ReadOnly]
    ] = scala
      .Option(impl.throughResources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ThroughResourcesStatementRequest.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AccessScopePathRequest
  ): zio.aws.ec2.model.AccessScopePathRequest.ReadOnly = new Wrapper(impl)
}
