package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TransitGatewayMulticastGroup(
    groupIpAddress: Option[String] = None,
    transitGatewayAttachmentId: Option[String] = None,
    subnetId: Option[String] = None,
    resourceId: Option[String] = None,
    resourceType: Option[
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = None,
    resourceOwnerId: Option[String] = None,
    networkInterfaceId: Option[String] = None,
    groupMember: Option[Boolean] = None,
    groupSource: Option[Boolean] = None,
    memberType: Option[zio.aws.ec2.model.MembershipType] = None,
    sourceType: Option[zio.aws.ec2.model.MembershipType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastGroup = {
    import TransitGatewayMulticastGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastGroup
      .builder()
      .optionallyWith(groupIpAddress.map(value => value: java.lang.String))(
        _.groupIpAddress
      )
      .optionallyWith(
        transitGatewayAttachmentId.map(value => value: java.lang.String)
      )(_.transitGatewayAttachmentId)
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(resourceOwnerId.map(value => value: java.lang.String))(
        _.resourceOwnerId
      )
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(groupMember.map(value => value: java.lang.Boolean))(
        _.groupMember
      )
      .optionallyWith(groupSource.map(value => value: java.lang.Boolean))(
        _.groupSource
      )
      .optionallyWith(memberType.map(value => value.unwrap))(_.memberType)
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayMulticastGroup.ReadOnly =
    zio.aws.ec2.model.TransitGatewayMulticastGroup.wrap(buildAwsValue())
}
object TransitGatewayMulticastGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayMulticastGroup =
      zio.aws.ec2.model.TransitGatewayMulticastGroup(
        groupIpAddress.map(value => value),
        transitGatewayAttachmentId.map(value => value),
        subnetId.map(value => value),
        resourceId.map(value => value),
        resourceType.map(value => value),
        resourceOwnerId.map(value => value),
        networkInterfaceId.map(value => value),
        groupMember.map(value => value),
        groupSource.map(value => value),
        memberType.map(value => value),
        sourceType.map(value => value)
      )
    def groupIpAddress: Option[String]
    def transitGatewayAttachmentId: Option[String]
    def subnetId: Option[String]
    def resourceId: Option[String]
    def resourceType
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentResourceType]
    def resourceOwnerId: Option[String]
    def networkInterfaceId: Option[String]
    def groupMember: Option[Boolean]
    def groupSource: Option[Boolean]
    def memberType: Option[zio.aws.ec2.model.MembershipType]
    def sourceType: Option[zio.aws.ec2.model.MembershipType]
    def getGroupIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupIpAddress", groupIpAddress)
    def getTransitGatewayAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwnerId", resourceOwnerId)
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getGroupMember: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("groupMember", groupMember)
    def getGroupSource: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("groupSource", groupSource)
    def getMemberType: ZIO[Any, AwsError, zio.aws.ec2.model.MembershipType] =
      AwsError.unwrapOptionField("memberType", memberType)
    def getSourceType: ZIO[Any, AwsError, zio.aws.ec2.model.MembershipType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastGroup
  ) extends zio.aws.ec2.model.TransitGatewayMulticastGroup.ReadOnly {
    override val groupIpAddress: Option[String] =
      scala.Option(impl.groupIpAddress()).map(value => value: String)
    override val transitGatewayAttachmentId: Option[String] = scala
      .Option(impl.transitGatewayAttachmentId())
      .map(value => value: String)
    override val subnetId: Option[String] =
      scala.Option(impl.subnetId()).map(value => value: String)
    override val resourceId: Option[String] =
      scala.Option(impl.resourceId()).map(value => value: String)
    override val resourceType
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayAttachmentResourceType.wrap(value)
      )
    override val resourceOwnerId: Option[String] =
      scala.Option(impl.resourceOwnerId()).map(value => value: String)
    override val networkInterfaceId: Option[String] =
      scala.Option(impl.networkInterfaceId()).map(value => value: String)
    override val groupMember: Option[Boolean] =
      scala.Option(impl.groupMember()).map(value => value: Boolean)
    override val groupSource: Option[Boolean] =
      scala.Option(impl.groupSource()).map(value => value: Boolean)
    override val memberType: Option[zio.aws.ec2.model.MembershipType] = scala
      .Option(impl.memberType())
      .map(value => zio.aws.ec2.model.MembershipType.wrap(value))
    override val sourceType: Option[zio.aws.ec2.model.MembershipType] = scala
      .Option(impl.sourceType())
      .map(value => zio.aws.ec2.model.MembershipType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastGroup
  ): zio.aws.ec2.model.TransitGatewayMulticastGroup.ReadOnly = new Wrapper(impl)
}
