package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TargetNetwork(
    associationId: Option[String] = None,
    vpcId: Option[String] = None,
    targetNetworkId: Option[String] = None,
    clientVpnEndpointId: Option[String] = None,
    status: Option[zio.aws.ec2.model.AssociationStatus] = None,
    securityGroups: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TargetNetwork = {
    import TargetNetwork.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TargetNetwork
      .builder()
      .optionallyWith(associationId.map(value => value: java.lang.String))(
        _.associationId
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(targetNetworkId.map(value => value: java.lang.String))(
        _.targetNetworkId
      )
      .optionallyWith(
        clientVpnEndpointId.map(value => value: java.lang.String)
      )(_.clientVpnEndpointId)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TargetNetwork.ReadOnly =
    zio.aws.ec2.model.TargetNetwork.wrap(buildAwsValue())
}
object TargetNetwork {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.TargetNetwork] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TargetNetwork =
      zio.aws.ec2.model.TargetNetwork(
        associationId.map(value => value),
        vpcId.map(value => value),
        targetNetworkId.map(value => value),
        clientVpnEndpointId.map(value => value),
        status.map(value => value.asEditable),
        securityGroups.map(value => value)
      )
    def associationId: Option[String]
    def vpcId: Option[String]
    def targetNetworkId: Option[String]
    def clientVpnEndpointId: Option[String]
    def status: Option[zio.aws.ec2.model.AssociationStatus.ReadOnly]
    def securityGroups: Option[List[String]]
    def getAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getTargetNetworkId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetNetworkId", targetNetworkId)
    def getClientVpnEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientVpnEndpointId", clientVpnEndpointId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.AssociationStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TargetNetwork
  ) extends zio.aws.ec2.model.TargetNetwork.ReadOnly {
    override val associationId: Option[String] =
      scala.Option(impl.associationId()).map(value => value: String)
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val targetNetworkId: Option[String] =
      scala.Option(impl.targetNetworkId()).map(value => value: String)
    override val clientVpnEndpointId: Option[String] =
      scala.Option(impl.clientVpnEndpointId()).map(value => value: String)
    override val status: Option[zio.aws.ec2.model.AssociationStatus.ReadOnly] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.ec2.model.AssociationStatus.wrap(value))
    override val securityGroups: Option[List[String]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TargetNetwork
  ): zio.aws.ec2.model.TargetNetwork.ReadOnly = new Wrapper(impl)
}
