package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait StaticSourcesSupportValue {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.StaticSourcesSupportValue
}
object StaticSourcesSupportValue {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.StaticSourcesSupportValue
  ): zio.aws.ec2.model.StaticSourcesSupportValue = value match {
    case software.amazon.awssdk.services.ec2.model.StaticSourcesSupportValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.StaticSourcesSupportValue.ENABLE =>
      val r = enable
      r
    case software.amazon.awssdk.services.ec2.model.StaticSourcesSupportValue.DISABLE =>
      val r = disable
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.StaticSourcesSupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.StaticSourcesSupportValue =
      software.amazon.awssdk.services.ec2.model.StaticSourcesSupportValue.UNKNOWN_TO_SDK_VERSION
  }
  case object enable extends zio.aws.ec2.model.StaticSourcesSupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.StaticSourcesSupportValue =
      software.amazon.awssdk.services.ec2.model.StaticSourcesSupportValue.ENABLE
  }
  case object disable extends zio.aws.ec2.model.StaticSourcesSupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.StaticSourcesSupportValue =
      software.amazon.awssdk.services.ec2.model.StaticSourcesSupportValue.DISABLE
  }
}
