package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, MillisecondDateTime}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class RestoreSnapshotTierResponse(
    snapshotId: Option[String] = None,
    restoreStartTime: Option[MillisecondDateTime] = None,
    restoreDuration: Option[Integer] = None,
    isPermanentRestore: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierResponse = {
    import RestoreSnapshotTierResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierResponse
      .builder()
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(
        restoreStartTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.restoreStartTime)
      .optionallyWith(restoreDuration.map(value => value: java.lang.Integer))(
        _.restoreDuration
      )
      .optionallyWith(
        isPermanentRestore.map(value => value: java.lang.Boolean)
      )(_.isPermanentRestore)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RestoreSnapshotTierResponse.ReadOnly =
    zio.aws.ec2.model.RestoreSnapshotTierResponse.wrap(buildAwsValue())
}
object RestoreSnapshotTierResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RestoreSnapshotTierResponse =
      zio.aws.ec2.model.RestoreSnapshotTierResponse(
        snapshotId.map(value => value),
        restoreStartTime.map(value => value),
        restoreDuration.map(value => value),
        isPermanentRestore.map(value => value)
      )
    def snapshotId: Option[String]
    def restoreStartTime: Option[MillisecondDateTime]
    def restoreDuration: Option[Integer]
    def isPermanentRestore: Option[Boolean]
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getRestoreStartTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("restoreStartTime", restoreStartTime)
    def getRestoreDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("restoreDuration", restoreDuration)
    def getIsPermanentRestore: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isPermanentRestore", isPermanentRestore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierResponse
  ) extends zio.aws.ec2.model.RestoreSnapshotTierResponse.ReadOnly {
    override val snapshotId: Option[String] =
      scala.Option(impl.snapshotId()).map(value => value: String)
    override val restoreStartTime: Option[MillisecondDateTime] = scala
      .Option(impl.restoreStartTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val restoreDuration: Option[Integer] =
      scala.Option(impl.restoreDuration()).map(value => value: Integer)
    override val isPermanentRestore: Option[Boolean] =
      scala.Option(impl.isPermanentRestore()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierResponse
  ): zio.aws.ec2.model.RestoreSnapshotTierResponse.ReadOnly = new Wrapper(impl)
}
