package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PtrUpdateStatus(
    value: Option[String] = None,
    status: Option[String] = None,
    reason: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PtrUpdateStatus = {
    import PtrUpdateStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PtrUpdateStatus
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PtrUpdateStatus.ReadOnly =
    zio.aws.ec2.model.PtrUpdateStatus.wrap(buildAwsValue())
}
object PtrUpdateStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PtrUpdateStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PtrUpdateStatus =
      zio.aws.ec2.model.PtrUpdateStatus(
        value.map(value => value),
        status.map(value => value),
        reason.map(value => value)
      )
    def value: Option[String]
    def status: Option[String]
    def reason: Option[String]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PtrUpdateStatus
  ) extends zio.aws.ec2.model.PtrUpdateStatus.ReadOnly {
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val reason: Option[String] =
      scala.Option(impl.reason()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PtrUpdateStatus
  ): zio.aws.ec2.model.PtrUpdateStatus.ReadOnly = new Wrapper(impl)
}
