package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class MonitorInstancesRequest(instanceIds: Iterable[InstanceId]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.MonitorInstancesRequest = {
    import MonitorInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.MonitorInstancesRequest
      .builder()
      .instanceIds(instanceIds.map { item =>
        InstanceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.MonitorInstancesRequest.ReadOnly =
    zio.aws.ec2.model.MonitorInstancesRequest.wrap(buildAwsValue())
}
object MonitorInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.MonitorInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.MonitorInstancesRequest =
      zio.aws.ec2.model.MonitorInstancesRequest(instanceIds)
    def instanceIds: List[InstanceId]
    def getInstanceIds: ZIO[Any, Nothing, List[InstanceId]] =
      ZIO.succeed(instanceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.MonitorInstancesRequest
  ) extends zio.aws.ec2.model.MonitorInstancesRequest.ReadOnly {
    override val instanceIds: List[InstanceId] = impl
      .instanceIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.InstanceId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.MonitorInstancesRequest
  ): zio.aws.ec2.model.MonitorInstancesRequest.ReadOnly = new Wrapper(impl)
}
