package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SubnetId, TransitGatewayAttachmentId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyTransitGatewayVpcAttachmentRequest(
    transitGatewayAttachmentId: TransitGatewayAttachmentId,
    addSubnetIds: Option[Iterable[SubnetId]] = None,
    removeSubnetIds: Option[Iterable[SubnetId]] = None,
    options: Option[
      zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequest = {
    import ModifyTransitGatewayVpcAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequest
      .builder()
      .transitGatewayAttachmentId(
        TransitGatewayAttachmentId.unwrap(
          transitGatewayAttachmentId
        ): java.lang.String
      )
      .optionallyWith(
        addSubnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.addSubnetIds)
      .optionallyWith(
        removeSubnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removeSubnetIds)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequest.ReadOnly =
    zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequest
      .wrap(buildAwsValue())
}
object ModifyTransitGatewayVpcAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequest =
      zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequest(
        transitGatewayAttachmentId,
        addSubnetIds.map(value => value),
        removeSubnetIds.map(value => value),
        options.map(value => value.asEditable)
      )
    def transitGatewayAttachmentId: TransitGatewayAttachmentId
    def addSubnetIds: Option[List[SubnetId]]
    def removeSubnetIds: Option[List[SubnetId]]
    def options: Option[
      zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions.ReadOnly
    ]
    def getTransitGatewayAttachmentId
        : ZIO[Any, Nothing, TransitGatewayAttachmentId] =
      ZIO.succeed(transitGatewayAttachmentId)
    def getAddSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("addSubnetIds", addSubnetIds)
    def getRemoveSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("removeSubnetIds", removeSubnetIds)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequest
  ) extends zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequest.ReadOnly {
    override val transitGatewayAttachmentId: TransitGatewayAttachmentId =
      zio.aws.ec2.model.primitives
        .TransitGatewayAttachmentId(impl.transitGatewayAttachmentId())
    override val addSubnetIds: Option[List[SubnetId]] = scala
      .Option(impl.addSubnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SubnetId(item)
        }.toList
      )
    override val removeSubnetIds: Option[List[SubnetId]] = scala
      .Option(impl.removeSubnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SubnetId(item)
        }.toList
      )
    override val options: Option[
      zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions.ReadOnly
    ] = scala
      .Option(impl.options())
      .map(value =>
        zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequest
  ): zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
