package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyTransitGatewayRequest(
    transitGatewayId: TransitGatewayId,
    description: Option[String] = None,
    options: Option[zio.aws.ec2.model.ModifyTransitGatewayOptions] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayRequest = {
    import ModifyTransitGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayRequest
      .builder()
      .transitGatewayId(
        TransitGatewayId.unwrap(transitGatewayId): java.lang.String
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyTransitGatewayRequest.ReadOnly =
    zio.aws.ec2.model.ModifyTransitGatewayRequest.wrap(buildAwsValue())
}
object ModifyTransitGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyTransitGatewayRequest =
      zio.aws.ec2.model.ModifyTransitGatewayRequest(
        transitGatewayId,
        description.map(value => value),
        options.map(value => value.asEditable)
      )
    def transitGatewayId: TransitGatewayId
    def description: Option[String]
    def options: Option[zio.aws.ec2.model.ModifyTransitGatewayOptions.ReadOnly]
    def getTransitGatewayId: ZIO[Any, Nothing, TransitGatewayId] =
      ZIO.succeed(transitGatewayId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ModifyTransitGatewayOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayRequest
  ) extends zio.aws.ec2.model.ModifyTransitGatewayRequest.ReadOnly {
    override val transitGatewayId: TransitGatewayId =
      zio.aws.ec2.model.primitives.TransitGatewayId(impl.transitGatewayId())
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val options
        : Option[zio.aws.ec2.model.ModifyTransitGatewayOptions.ReadOnly] = scala
      .Option(impl.options())
      .map(value => zio.aws.ec2.model.ModifyTransitGatewayOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayRequest
  ): zio.aws.ec2.model.ModifyTransitGatewayRequest.ReadOnly = new Wrapper(impl)
}
