package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  Integer,
  InstanceId,
  DedicatedHostId,
  PlacementGroupName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyInstancePlacementRequest(
    affinity: Option[zio.aws.ec2.model.Affinity] = None,
    groupName: Option[PlacementGroupName] = None,
    hostId: Option[DedicatedHostId] = None,
    instanceId: InstanceId,
    tenancy: Option[zio.aws.ec2.model.HostTenancy] = None,
    partitionNumber: Option[Integer] = None,
    hostResourceGroupArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementRequest = {
    import ModifyInstancePlacementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementRequest
      .builder()
      .optionallyWith(affinity.map(value => value.unwrap))(_.affinity)
      .optionallyWith(
        groupName.map(value =>
          PlacementGroupName.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .optionallyWith(
        hostId.map(value => DedicatedHostId.unwrap(value): java.lang.String)
      )(_.hostId)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(tenancy.map(value => value.unwrap))(_.tenancy)
      .optionallyWith(partitionNumber.map(value => value: java.lang.Integer))(
        _.partitionNumber
      )
      .optionallyWith(
        hostResourceGroupArn.map(value => value: java.lang.String)
      )(_.hostResourceGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyInstancePlacementRequest.ReadOnly =
    zio.aws.ec2.model.ModifyInstancePlacementRequest.wrap(buildAwsValue())
}
object ModifyInstancePlacementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyInstancePlacementRequest =
      zio.aws.ec2.model.ModifyInstancePlacementRequest(
        affinity.map(value => value),
        groupName.map(value => value),
        hostId.map(value => value),
        instanceId,
        tenancy.map(value => value),
        partitionNumber.map(value => value),
        hostResourceGroupArn.map(value => value)
      )
    def affinity: Option[zio.aws.ec2.model.Affinity]
    def groupName: Option[PlacementGroupName]
    def hostId: Option[DedicatedHostId]
    def instanceId: InstanceId
    def tenancy: Option[zio.aws.ec2.model.HostTenancy]
    def partitionNumber: Option[Integer]
    def hostResourceGroupArn: Option[String]
    def getAffinity: ZIO[Any, AwsError, zio.aws.ec2.model.Affinity] =
      AwsError.unwrapOptionField("affinity", affinity)
    def getGroupName: ZIO[Any, AwsError, PlacementGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getHostId: ZIO[Any, AwsError, DedicatedHostId] =
      AwsError.unwrapOptionField("hostId", hostId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getTenancy: ZIO[Any, AwsError, zio.aws.ec2.model.HostTenancy] =
      AwsError.unwrapOptionField("tenancy", tenancy)
    def getPartitionNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("partitionNumber", partitionNumber)
    def getHostResourceGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostResourceGroupArn", hostResourceGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementRequest
  ) extends zio.aws.ec2.model.ModifyInstancePlacementRequest.ReadOnly {
    override val affinity: Option[zio.aws.ec2.model.Affinity] = scala
      .Option(impl.affinity())
      .map(value => zio.aws.ec2.model.Affinity.wrap(value))
    override val groupName: Option[PlacementGroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.ec2.model.primitives.PlacementGroupName(value))
    override val hostId: Option[DedicatedHostId] = scala
      .Option(impl.hostId())
      .map(value => zio.aws.ec2.model.primitives.DedicatedHostId(value))
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val tenancy: Option[zio.aws.ec2.model.HostTenancy] = scala
      .Option(impl.tenancy())
      .map(value => zio.aws.ec2.model.HostTenancy.wrap(value))
    override val partitionNumber: Option[Integer] =
      scala.Option(impl.partitionNumber()).map(value => value: Integer)
    override val hostResourceGroupArn: Option[String] =
      scala.Option(impl.hostResourceGroupArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementRequest
  ): zio.aws.ec2.model.ModifyInstancePlacementRequest.ReadOnly = new Wrapper(
    impl
  )
}
