package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoadBalancersConfig(
    classicLoadBalancersConfig: Option[
      zio.aws.ec2.model.ClassicLoadBalancersConfig
    ] = None,
    targetGroupsConfig: Option[zio.aws.ec2.model.TargetGroupsConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LoadBalancersConfig = {
    import LoadBalancersConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LoadBalancersConfig
      .builder()
      .optionallyWith(
        classicLoadBalancersConfig.map(value => value.buildAwsValue())
      )(_.classicLoadBalancersConfig)
      .optionallyWith(targetGroupsConfig.map(value => value.buildAwsValue()))(
        _.targetGroupsConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LoadBalancersConfig.ReadOnly =
    zio.aws.ec2.model.LoadBalancersConfig.wrap(buildAwsValue())
}
object LoadBalancersConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LoadBalancersConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LoadBalancersConfig =
      zio.aws.ec2.model.LoadBalancersConfig(
        classicLoadBalancersConfig.map(value => value.asEditable),
        targetGroupsConfig.map(value => value.asEditable)
      )
    def classicLoadBalancersConfig
        : Option[zio.aws.ec2.model.ClassicLoadBalancersConfig.ReadOnly]
    def targetGroupsConfig
        : Option[zio.aws.ec2.model.TargetGroupsConfig.ReadOnly]
    def getClassicLoadBalancersConfig: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClassicLoadBalancersConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "classicLoadBalancersConfig",
      classicLoadBalancersConfig
    )
    def getTargetGroupsConfig
        : ZIO[Any, AwsError, zio.aws.ec2.model.TargetGroupsConfig.ReadOnly] =
      AwsError.unwrapOptionField("targetGroupsConfig", targetGroupsConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LoadBalancersConfig
  ) extends zio.aws.ec2.model.LoadBalancersConfig.ReadOnly {
    override val classicLoadBalancersConfig
        : Option[zio.aws.ec2.model.ClassicLoadBalancersConfig.ReadOnly] = scala
      .Option(impl.classicLoadBalancersConfig())
      .map(value => zio.aws.ec2.model.ClassicLoadBalancersConfig.wrap(value))
    override val targetGroupsConfig
        : Option[zio.aws.ec2.model.TargetGroupsConfig.ReadOnly] = scala
      .Option(impl.targetGroupsConfig())
      .map(value => zio.aws.ec2.model.TargetGroupsConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LoadBalancersConfig
  ): zio.aws.ec2.model.LoadBalancersConfig.ReadOnly = new Wrapper(impl)
}
