package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{ListImagesInRecycleBinMaxResults, ImageId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListImagesInRecycleBinRequest(
    imageIds: Option[Iterable[ImageId]] = None,
    nextToken: Option[String] = None,
    maxResults: Option[ListImagesInRecycleBinMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinRequest = {
    import ListImagesInRecycleBinRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinRequest
      .builder()
      .optionallyWith(
        imageIds.map(value =>
          value.map { item =>
            ImageId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.imageIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          ListImagesInRecycleBinMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ListImagesInRecycleBinRequest.ReadOnly =
    zio.aws.ec2.model.ListImagesInRecycleBinRequest.wrap(buildAwsValue())
}
object ListImagesInRecycleBinRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ListImagesInRecycleBinRequest =
      zio.aws.ec2.model.ListImagesInRecycleBinRequest(
        imageIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def imageIds: Option[List[ImageId]]
    def nextToken: Option[String]
    def maxResults: Option[ListImagesInRecycleBinMaxResults]
    def getImageIds: ZIO[Any, AwsError, List[ImageId]] =
      AwsError.unwrapOptionField("imageIds", imageIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListImagesInRecycleBinMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinRequest
  ) extends zio.aws.ec2.model.ListImagesInRecycleBinRequest.ReadOnly {
    override val imageIds: Option[List[ImageId]] = scala
      .Option(impl.imageIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.ImageId(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[ListImagesInRecycleBinMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.ListImagesInRecycleBinMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinRequest
  ): zio.aws.ec2.model.ListImagesInRecycleBinRequest.ReadOnly = new Wrapper(
    impl
  )
}
