package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{DateTime, LaunchTemplateName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class LaunchTemplate(
    launchTemplateId: Option[String] = None,
    launchTemplateName: Option[LaunchTemplateName] = None,
    createTime: Option[DateTime] = None,
    createdBy: Option[String] = None,
    defaultVersionNumber: Option[Long] = None,
    latestVersionNumber: Option[Long] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplate = {
    import LaunchTemplate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplate
      .builder()
      .optionallyWith(launchTemplateId.map(value => value: java.lang.String))(
        _.launchTemplateId
      )
      .optionallyWith(
        launchTemplateName.map(value =>
          LaunchTemplateName.unwrap(value): java.lang.String
        )
      )(_.launchTemplateName)
      .optionallyWith(createTime.map(value => DateTime.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(defaultVersionNumber.map(value => value: java.lang.Long))(
        _.defaultVersionNumber
      )
      .optionallyWith(latestVersionNumber.map(value => value: java.lang.Long))(
        _.latestVersionNumber
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LaunchTemplate.ReadOnly =
    zio.aws.ec2.model.LaunchTemplate.wrap(buildAwsValue())
}
object LaunchTemplate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplate =
      zio.aws.ec2.model.LaunchTemplate(
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        createTime.map(value => value),
        createdBy.map(value => value),
        defaultVersionNumber.map(value => value),
        latestVersionNumber.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def launchTemplateId: Option[String]
    def launchTemplateName: Option[LaunchTemplateName]
    def createTime: Option[DateTime]
    def createdBy: Option[String]
    def defaultVersionNumber: Option[Long]
    def latestVersionNumber: Option[Long]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getLaunchTemplateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, LaunchTemplateName] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getCreateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getDefaultVersionNumber: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("defaultVersionNumber", defaultVersionNumber)
    def getLatestVersionNumber: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("latestVersionNumber", latestVersionNumber)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplate
  ) extends zio.aws.ec2.model.LaunchTemplate.ReadOnly {
    override val launchTemplateId: Option[String] =
      scala.Option(impl.launchTemplateId()).map(value => value: String)
    override val launchTemplateName: Option[LaunchTemplateName] = scala
      .Option(impl.launchTemplateName())
      .map(value => zio.aws.ec2.model.primitives.LaunchTemplateName(value))
    override val createTime: Option[DateTime] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val createdBy: Option[String] =
      scala.Option(impl.createdBy()).map(value => value: String)
    override val defaultVersionNumber: Option[Long] =
      scala.Option(impl.defaultVersionNumber()).map(value => value: Long)
    override val latestVersionNumber: Option[Long] =
      scala.Option(impl.latestVersionNumber()).map(value => value: Long)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplate
  ): zio.aws.ec2.model.LaunchTemplate.ReadOnly = new Wrapper(impl)
}
