package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait IpamPoolState {
  def unwrap: software.amazon.awssdk.services.ec2.model.IpamPoolState
}
object IpamPoolState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.IpamPoolState
  ): zio.aws.ec2.model.IpamPoolState = value match {
    case software.amazon.awssdk.services.ec2.model.IpamPoolState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolState.CREATE_IN_PROGRESS =>
      val r = `create-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolState.CREATE_COMPLETE =>
      val r = `create-complete`
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolState.CREATE_FAILED =>
      val r = `create-failed`
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolState.MODIFY_IN_PROGRESS =>
      val r = `modify-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolState.MODIFY_COMPLETE =>
      val r = `modify-complete`
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolState.MODIFY_FAILED =>
      val r = `modify-failed`
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolState.DELETE_IN_PROGRESS =>
      val r = `delete-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolState.DELETE_COMPLETE =>
      val r = `delete-complete`
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolState.DELETE_FAILED =>
      val r = `delete-failed`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.IpamPoolState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolState =
      software.amazon.awssdk.services.ec2.model.IpamPoolState.UNKNOWN_TO_SDK_VERSION
  }
  case object `create-in-progress` extends zio.aws.ec2.model.IpamPoolState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolState =
      software.amazon.awssdk.services.ec2.model.IpamPoolState.CREATE_IN_PROGRESS
  }
  case object `create-complete` extends zio.aws.ec2.model.IpamPoolState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolState =
      software.amazon.awssdk.services.ec2.model.IpamPoolState.CREATE_COMPLETE
  }
  case object `create-failed` extends zio.aws.ec2.model.IpamPoolState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolState =
      software.amazon.awssdk.services.ec2.model.IpamPoolState.CREATE_FAILED
  }
  case object `modify-in-progress` extends zio.aws.ec2.model.IpamPoolState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolState =
      software.amazon.awssdk.services.ec2.model.IpamPoolState.MODIFY_IN_PROGRESS
  }
  case object `modify-complete` extends zio.aws.ec2.model.IpamPoolState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolState =
      software.amazon.awssdk.services.ec2.model.IpamPoolState.MODIFY_COMPLETE
  }
  case object `modify-failed` extends zio.aws.ec2.model.IpamPoolState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolState =
      software.amazon.awssdk.services.ec2.model.IpamPoolState.MODIFY_FAILED
  }
  case object `delete-in-progress` extends zio.aws.ec2.model.IpamPoolState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolState =
      software.amazon.awssdk.services.ec2.model.IpamPoolState.DELETE_IN_PROGRESS
  }
  case object `delete-complete` extends zio.aws.ec2.model.IpamPoolState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolState =
      software.amazon.awssdk.services.ec2.model.IpamPoolState.DELETE_COMPLETE
  }
  case object `delete-failed` extends zio.aws.ec2.model.IpamPoolState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolState =
      software.amazon.awssdk.services.ec2.model.IpamPoolState.DELETE_FAILED
  }
}
