package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamPoolAllocationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IpamPoolAllocation(
    cidr: Option[String] = None,
    ipamPoolAllocationId: Option[IpamPoolAllocationId] = None,
    description: Option[String] = None,
    resourceId: Option[String] = None,
    resourceType: Option[zio.aws.ec2.model.IpamPoolAllocationResourceType] =
      None,
    resourceRegion: Option[String] = None,
    resourceOwner: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IpamPoolAllocation = {
    import IpamPoolAllocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpamPoolAllocation
      .builder()
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .optionallyWith(
        ipamPoolAllocationId.map(value =>
          IpamPoolAllocationId.unwrap(value): java.lang.String
        )
      )(_.ipamPoolAllocationId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(resourceRegion.map(value => value: java.lang.String))(
        _.resourceRegion
      )
      .optionallyWith(resourceOwner.map(value => value: java.lang.String))(
        _.resourceOwner
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpamPoolAllocation.ReadOnly =
    zio.aws.ec2.model.IpamPoolAllocation.wrap(buildAwsValue())
}
object IpamPoolAllocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.IpamPoolAllocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpamPoolAllocation =
      zio.aws.ec2.model.IpamPoolAllocation(
        cidr.map(value => value),
        ipamPoolAllocationId.map(value => value),
        description.map(value => value),
        resourceId.map(value => value),
        resourceType.map(value => value),
        resourceRegion.map(value => value),
        resourceOwner.map(value => value)
      )
    def cidr: Option[String]
    def ipamPoolAllocationId: Option[IpamPoolAllocationId]
    def description: Option[String]
    def resourceId: Option[String]
    def resourceType: Option[zio.aws.ec2.model.IpamPoolAllocationResourceType]
    def resourceRegion: Option[String]
    def resourceOwner: Option[String]
    def getCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidr", cidr)
    def getIpamPoolAllocationId: ZIO[Any, AwsError, IpamPoolAllocationId] =
      AwsError.unwrapOptionField("ipamPoolAllocationId", ipamPoolAllocationId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamPoolAllocationResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceRegion", resourceRegion)
    def getResourceOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwner", resourceOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpamPoolAllocation
  ) extends zio.aws.ec2.model.IpamPoolAllocation.ReadOnly {
    override val cidr: Option[String] =
      scala.Option(impl.cidr()).map(value => value: String)
    override val ipamPoolAllocationId: Option[IpamPoolAllocationId] = scala
      .Option(impl.ipamPoolAllocationId())
      .map(value => zio.aws.ec2.model.primitives.IpamPoolAllocationId(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val resourceId: Option[String] =
      scala.Option(impl.resourceId()).map(value => value: String)
    override val resourceType
        : Option[zio.aws.ec2.model.IpamPoolAllocationResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.ec2.model.IpamPoolAllocationResourceType.wrap(value)
      )
    override val resourceRegion: Option[String] =
      scala.Option(impl.resourceRegion()).map(value => value: String)
    override val resourceOwner: Option[String] =
      scala.Option(impl.resourceOwner()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpamPoolAllocation
  ): zio.aws.ec2.model.IpamPoolAllocation.ReadOnly = new Wrapper(impl)
}
