package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IpamOperatingRegion(regionName: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IpamOperatingRegion = {
    import IpamOperatingRegion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpamOperatingRegion
      .builder()
      .optionallyWith(regionName.map(value => value: java.lang.String))(
        _.regionName
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpamOperatingRegion.ReadOnly =
    zio.aws.ec2.model.IpamOperatingRegion.wrap(buildAwsValue())
}
object IpamOperatingRegion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.IpamOperatingRegion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpamOperatingRegion =
      zio.aws.ec2.model.IpamOperatingRegion(regionName.map(value => value))
    def regionName: Option[String]
    def getRegionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("regionName", regionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpamOperatingRegion
  ) extends zio.aws.ec2.model.IpamOperatingRegion.ReadOnly {
    override val regionName: Option[String] =
      scala.Option(impl.regionName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpamOperatingRegion
  ): zio.aws.ec2.model.IpamOperatingRegion.ReadOnly = new Wrapper(impl)
}
