package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceTagNotificationAttribute(
    instanceTagKeys: Option[Iterable[String]] = None,
    includeAllTagsOfInstance: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceTagNotificationAttribute = {
    import InstanceTagNotificationAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceTagNotificationAttribute
      .builder()
      .optionallyWith(
        instanceTagKeys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.instanceTagKeys)
      .optionallyWith(
        includeAllTagsOfInstance.map(value => value: java.lang.Boolean)
      )(_.includeAllTagsOfInstance)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceTagNotificationAttribute.ReadOnly =
    zio.aws.ec2.model.InstanceTagNotificationAttribute.wrap(buildAwsValue())
}
object InstanceTagNotificationAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceTagNotificationAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceTagNotificationAttribute =
      zio.aws.ec2.model.InstanceTagNotificationAttribute(
        instanceTagKeys.map(value => value),
        includeAllTagsOfInstance.map(value => value)
      )
    def instanceTagKeys: Option[List[String]]
    def includeAllTagsOfInstance: Option[Boolean]
    def getInstanceTagKeys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("instanceTagKeys", instanceTagKeys)
    def getIncludeAllTagsOfInstance: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("includeAllTagsOfInstance", includeAllTagsOfInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceTagNotificationAttribute
  ) extends zio.aws.ec2.model.InstanceTagNotificationAttribute.ReadOnly {
    override val instanceTagKeys: Option[List[String]] = scala
      .Option(impl.instanceTagKeys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val includeAllTagsOfInstance: Option[Boolean] =
      scala.Option(impl.includeAllTagsOfInstance()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceTagNotificationAttribute
  ): zio.aws.ec2.model.InstanceTagNotificationAttribute.ReadOnly = new Wrapper(
    impl
  )
}
