package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait InstanceStorageEncryptionSupport {
  def unwrap: software.amazon.awssdk.services.ec2.model.InstanceStorageEncryptionSupport
}
object InstanceStorageEncryptionSupport {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.InstanceStorageEncryptionSupport
  ): zio.aws.ec2.model.InstanceStorageEncryptionSupport = value match {
    case software.amazon.awssdk.services.ec2.model.InstanceStorageEncryptionSupport.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.InstanceStorageEncryptionSupport.UNSUPPORTED =>
      val r = unsupported
      r
    case software.amazon.awssdk.services.ec2.model.InstanceStorageEncryptionSupport.REQUIRED =>
      val r = required
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.InstanceStorageEncryptionSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceStorageEncryptionSupport =
      software.amazon.awssdk.services.ec2.model.InstanceStorageEncryptionSupport.UNKNOWN_TO_SDK_VERSION
  }
  case object unsupported
      extends zio.aws.ec2.model.InstanceStorageEncryptionSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceStorageEncryptionSupport =
      software.amazon.awssdk.services.ec2.model.InstanceStorageEncryptionSupport.UNSUPPORTED
  }
  case object required
      extends zio.aws.ec2.model.InstanceStorageEncryptionSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceStorageEncryptionSupport =
      software.amazon.awssdk.services.ec2.model.InstanceStorageEncryptionSupport.REQUIRED
  }
}
