package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, ExcludedInstanceType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceRequirementsRequest(
    vCpuCount: zio.aws.ec2.model.VCpuCountRangeRequest,
    memoryMiB: zio.aws.ec2.model.MemoryMiBRequest,
    cpuManufacturers: Option[Iterable[zio.aws.ec2.model.CpuManufacturer]] =
      None,
    memoryGiBPerVCpu: Option[zio.aws.ec2.model.MemoryGiBPerVCpuRequest] = None,
    excludedInstanceTypes: Option[Iterable[ExcludedInstanceType]] = None,
    instanceGenerations: Option[
      Iterable[zio.aws.ec2.model.InstanceGeneration]
    ] = None,
    spotMaxPricePercentageOverLowestPrice: Option[Integer] = None,
    onDemandMaxPricePercentageOverLowestPrice: Option[Integer] = None,
    bareMetal: Option[zio.aws.ec2.model.BareMetal] = None,
    burstablePerformance: Option[zio.aws.ec2.model.BurstablePerformance] = None,
    requireHibernateSupport: Option[Boolean] = None,
    networkInterfaceCount: Option[
      zio.aws.ec2.model.NetworkInterfaceCountRequest
    ] = None,
    localStorage: Option[zio.aws.ec2.model.LocalStorage] = None,
    localStorageTypes: Option[Iterable[zio.aws.ec2.model.LocalStorageType]] =
      None,
    totalLocalStorageGB: Option[zio.aws.ec2.model.TotalLocalStorageGBRequest] =
      None,
    baselineEbsBandwidthMbps: Option[
      zio.aws.ec2.model.BaselineEbsBandwidthMbpsRequest
    ] = None,
    acceleratorTypes: Option[Iterable[zio.aws.ec2.model.AcceleratorType]] =
      None,
    acceleratorCount: Option[zio.aws.ec2.model.AcceleratorCountRequest] = None,
    acceleratorManufacturers: Option[
      Iterable[zio.aws.ec2.model.AcceleratorManufacturer]
    ] = None,
    acceleratorNames: Option[Iterable[zio.aws.ec2.model.AcceleratorName]] =
      None,
    acceleratorTotalMemoryMiB: Option[
      zio.aws.ec2.model.AcceleratorTotalMemoryMiBRequest
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceRequirementsRequest = {
    import InstanceRequirementsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceRequirementsRequest
      .builder()
      .vCpuCount(vCpuCount.buildAwsValue())
      .memoryMiB(memoryMiB.buildAwsValue())
      .optionallyWith(
        cpuManufacturers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.cpuManufacturersWithStrings)
      .optionallyWith(memoryGiBPerVCpu.map(value => value.buildAwsValue()))(
        _.memoryGiBPerVCpu
      )
      .optionallyWith(
        excludedInstanceTypes.map(value =>
          value.map { item =>
            ExcludedInstanceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludedInstanceTypes)
      .optionallyWith(
        instanceGenerations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.instanceGenerationsWithStrings)
      .optionallyWith(
        spotMaxPricePercentageOverLowestPrice.map(value =>
          value: java.lang.Integer
        )
      )(_.spotMaxPricePercentageOverLowestPrice)
      .optionallyWith(
        onDemandMaxPricePercentageOverLowestPrice.map(value =>
          value: java.lang.Integer
        )
      )(_.onDemandMaxPricePercentageOverLowestPrice)
      .optionallyWith(bareMetal.map(value => value.unwrap))(_.bareMetal)
      .optionallyWith(burstablePerformance.map(value => value.unwrap))(
        _.burstablePerformance
      )
      .optionallyWith(
        requireHibernateSupport.map(value => value: java.lang.Boolean)
      )(_.requireHibernateSupport)
      .optionallyWith(
        networkInterfaceCount.map(value => value.buildAwsValue())
      )(_.networkInterfaceCount)
      .optionallyWith(localStorage.map(value => value.unwrap))(_.localStorage)
      .optionallyWith(
        localStorageTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.localStorageTypesWithStrings)
      .optionallyWith(totalLocalStorageGB.map(value => value.buildAwsValue()))(
        _.totalLocalStorageGB
      )
      .optionallyWith(
        baselineEbsBandwidthMbps.map(value => value.buildAwsValue())
      )(_.baselineEbsBandwidthMbps)
      .optionallyWith(
        acceleratorTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.acceleratorTypesWithStrings)
      .optionallyWith(acceleratorCount.map(value => value.buildAwsValue()))(
        _.acceleratorCount
      )
      .optionallyWith(
        acceleratorManufacturers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.acceleratorManufacturersWithStrings)
      .optionallyWith(
        acceleratorNames.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.acceleratorNamesWithStrings)
      .optionallyWith(
        acceleratorTotalMemoryMiB.map(value => value.buildAwsValue())
      )(_.acceleratorTotalMemoryMiB)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceRequirementsRequest.ReadOnly =
    zio.aws.ec2.model.InstanceRequirementsRequest.wrap(buildAwsValue())
}
object InstanceRequirementsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceRequirementsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceRequirementsRequest =
      zio.aws.ec2.model.InstanceRequirementsRequest(
        vCpuCount.asEditable,
        memoryMiB.asEditable,
        cpuManufacturers.map(value => value),
        memoryGiBPerVCpu.map(value => value.asEditable),
        excludedInstanceTypes.map(value => value),
        instanceGenerations.map(value => value),
        spotMaxPricePercentageOverLowestPrice.map(value => value),
        onDemandMaxPricePercentageOverLowestPrice.map(value => value),
        bareMetal.map(value => value),
        burstablePerformance.map(value => value),
        requireHibernateSupport.map(value => value),
        networkInterfaceCount.map(value => value.asEditable),
        localStorage.map(value => value),
        localStorageTypes.map(value => value),
        totalLocalStorageGB.map(value => value.asEditable),
        baselineEbsBandwidthMbps.map(value => value.asEditable),
        acceleratorTypes.map(value => value),
        acceleratorCount.map(value => value.asEditable),
        acceleratorManufacturers.map(value => value),
        acceleratorNames.map(value => value),
        acceleratorTotalMemoryMiB.map(value => value.asEditable)
      )
    def vCpuCount: zio.aws.ec2.model.VCpuCountRangeRequest.ReadOnly
    def memoryMiB: zio.aws.ec2.model.MemoryMiBRequest.ReadOnly
    def cpuManufacturers: Option[List[zio.aws.ec2.model.CpuManufacturer]]
    def memoryGiBPerVCpu
        : Option[zio.aws.ec2.model.MemoryGiBPerVCpuRequest.ReadOnly]
    def excludedInstanceTypes: Option[List[ExcludedInstanceType]]
    def instanceGenerations: Option[List[zio.aws.ec2.model.InstanceGeneration]]
    def spotMaxPricePercentageOverLowestPrice: Option[Integer]
    def onDemandMaxPricePercentageOverLowestPrice: Option[Integer]
    def bareMetal: Option[zio.aws.ec2.model.BareMetal]
    def burstablePerformance: Option[zio.aws.ec2.model.BurstablePerformance]
    def requireHibernateSupport: Option[Boolean]
    def networkInterfaceCount
        : Option[zio.aws.ec2.model.NetworkInterfaceCountRequest.ReadOnly]
    def localStorage: Option[zio.aws.ec2.model.LocalStorage]
    def localStorageTypes: Option[List[zio.aws.ec2.model.LocalStorageType]]
    def totalLocalStorageGB
        : Option[zio.aws.ec2.model.TotalLocalStorageGBRequest.ReadOnly]
    def baselineEbsBandwidthMbps
        : Option[zio.aws.ec2.model.BaselineEbsBandwidthMbpsRequest.ReadOnly]
    def acceleratorTypes: Option[List[zio.aws.ec2.model.AcceleratorType]]
    def acceleratorCount
        : Option[zio.aws.ec2.model.AcceleratorCountRequest.ReadOnly]
    def acceleratorManufacturers
        : Option[List[zio.aws.ec2.model.AcceleratorManufacturer]]
    def acceleratorNames: Option[List[zio.aws.ec2.model.AcceleratorName]]
    def acceleratorTotalMemoryMiB
        : Option[zio.aws.ec2.model.AcceleratorTotalMemoryMiBRequest.ReadOnly]
    def getVCpuCount
        : ZIO[Any, Nothing, zio.aws.ec2.model.VCpuCountRangeRequest.ReadOnly] =
      ZIO.succeed(vCpuCount)
    def getMemoryMiB
        : ZIO[Any, Nothing, zio.aws.ec2.model.MemoryMiBRequest.ReadOnly] =
      ZIO.succeed(memoryMiB)
    def getCpuManufacturers
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.CpuManufacturer]] =
      AwsError.unwrapOptionField("cpuManufacturers", cpuManufacturers)
    def getMemoryGiBPerVCpu: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.MemoryGiBPerVCpuRequest.ReadOnly
    ] = AwsError.unwrapOptionField("memoryGiBPerVCpu", memoryGiBPerVCpu)
    def getExcludedInstanceTypes
        : ZIO[Any, AwsError, List[ExcludedInstanceType]] =
      AwsError.unwrapOptionField("excludedInstanceTypes", excludedInstanceTypes)
    def getInstanceGenerations
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.InstanceGeneration]] =
      AwsError.unwrapOptionField("instanceGenerations", instanceGenerations)
    def getSpotMaxPricePercentageOverLowestPrice: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "spotMaxPricePercentageOverLowestPrice",
        spotMaxPricePercentageOverLowestPrice
      )
    def getOnDemandMaxPricePercentageOverLowestPrice
        : ZIO[Any, AwsError, Integer] = AwsError.unwrapOptionField(
      "onDemandMaxPricePercentageOverLowestPrice",
      onDemandMaxPricePercentageOverLowestPrice
    )
    def getBareMetal: ZIO[Any, AwsError, zio.aws.ec2.model.BareMetal] =
      AwsError.unwrapOptionField("bareMetal", bareMetal)
    def getBurstablePerformance
        : ZIO[Any, AwsError, zio.aws.ec2.model.BurstablePerformance] =
      AwsError.unwrapOptionField("burstablePerformance", burstablePerformance)
    def getRequireHibernateSupport: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("requireHibernateSupport", requireHibernateSupport)
    def getNetworkInterfaceCount: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInterfaceCountRequest.ReadOnly
    ] =
      AwsError.unwrapOptionField("networkInterfaceCount", networkInterfaceCount)
    def getLocalStorage: ZIO[Any, AwsError, zio.aws.ec2.model.LocalStorage] =
      AwsError.unwrapOptionField("localStorage", localStorage)
    def getLocalStorageTypes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.LocalStorageType]] =
      AwsError.unwrapOptionField("localStorageTypes", localStorageTypes)
    def getTotalLocalStorageGB: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TotalLocalStorageGBRequest.ReadOnly
    ] = AwsError.unwrapOptionField("totalLocalStorageGB", totalLocalStorageGB)
    def getBaselineEbsBandwidthMbps: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.BaselineEbsBandwidthMbpsRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "baselineEbsBandwidthMbps",
      baselineEbsBandwidthMbps
    )
    def getAcceleratorTypes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.AcceleratorType]] =
      AwsError.unwrapOptionField("acceleratorTypes", acceleratorTypes)
    def getAcceleratorCount: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AcceleratorCountRequest.ReadOnly
    ] = AwsError.unwrapOptionField("acceleratorCount", acceleratorCount)
    def getAcceleratorManufacturers
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.AcceleratorManufacturer]] =
      AwsError.unwrapOptionField(
        "acceleratorManufacturers",
        acceleratorManufacturers
      )
    def getAcceleratorNames
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.AcceleratorName]] =
      AwsError.unwrapOptionField("acceleratorNames", acceleratorNames)
    def getAcceleratorTotalMemoryMiB: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AcceleratorTotalMemoryMiBRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "acceleratorTotalMemoryMiB",
      acceleratorTotalMemoryMiB
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceRequirementsRequest
  ) extends zio.aws.ec2.model.InstanceRequirementsRequest.ReadOnly {
    override val vCpuCount: zio.aws.ec2.model.VCpuCountRangeRequest.ReadOnly =
      zio.aws.ec2.model.VCpuCountRangeRequest.wrap(impl.vCpuCount())
    override val memoryMiB: zio.aws.ec2.model.MemoryMiBRequest.ReadOnly =
      zio.aws.ec2.model.MemoryMiBRequest.wrap(impl.memoryMiB())
    override val cpuManufacturers
        : Option[List[zio.aws.ec2.model.CpuManufacturer]] = scala
      .Option(impl.cpuManufacturers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.CpuManufacturer.wrap(item)
        }.toList
      )
    override val memoryGiBPerVCpu
        : Option[zio.aws.ec2.model.MemoryGiBPerVCpuRequest.ReadOnly] = scala
      .Option(impl.memoryGiBPerVCpu())
      .map(value => zio.aws.ec2.model.MemoryGiBPerVCpuRequest.wrap(value))
    override val excludedInstanceTypes: Option[List[ExcludedInstanceType]] =
      scala
        .Option(impl.excludedInstanceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.ExcludedInstanceType(item)
          }.toList
        )
    override val instanceGenerations
        : Option[List[zio.aws.ec2.model.InstanceGeneration]] = scala
      .Option(impl.instanceGenerations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceGeneration.wrap(item)
        }.toList
      )
    override val spotMaxPricePercentageOverLowestPrice: Option[Integer] = scala
      .Option(impl.spotMaxPricePercentageOverLowestPrice())
      .map(value => value: Integer)
    override val onDemandMaxPricePercentageOverLowestPrice: Option[Integer] =
      scala
        .Option(impl.onDemandMaxPricePercentageOverLowestPrice())
        .map(value => value: Integer)
    override val bareMetal: Option[zio.aws.ec2.model.BareMetal] = scala
      .Option(impl.bareMetal())
      .map(value => zio.aws.ec2.model.BareMetal.wrap(value))
    override val burstablePerformance
        : Option[zio.aws.ec2.model.BurstablePerformance] = scala
      .Option(impl.burstablePerformance())
      .map(value => zio.aws.ec2.model.BurstablePerformance.wrap(value))
    override val requireHibernateSupport: Option[Boolean] =
      scala.Option(impl.requireHibernateSupport()).map(value => value: Boolean)
    override val networkInterfaceCount
        : Option[zio.aws.ec2.model.NetworkInterfaceCountRequest.ReadOnly] =
      scala
        .Option(impl.networkInterfaceCount())
        .map(value =>
          zio.aws.ec2.model.NetworkInterfaceCountRequest.wrap(value)
        )
    override val localStorage: Option[zio.aws.ec2.model.LocalStorage] = scala
      .Option(impl.localStorage())
      .map(value => zio.aws.ec2.model.LocalStorage.wrap(value))
    override val localStorageTypes
        : Option[List[zio.aws.ec2.model.LocalStorageType]] = scala
      .Option(impl.localStorageTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LocalStorageType.wrap(item)
        }.toList
      )
    override val totalLocalStorageGB
        : Option[zio.aws.ec2.model.TotalLocalStorageGBRequest.ReadOnly] = scala
      .Option(impl.totalLocalStorageGB())
      .map(value => zio.aws.ec2.model.TotalLocalStorageGBRequest.wrap(value))
    override val baselineEbsBandwidthMbps
        : Option[zio.aws.ec2.model.BaselineEbsBandwidthMbpsRequest.ReadOnly] =
      scala
        .Option(impl.baselineEbsBandwidthMbps())
        .map(value =>
          zio.aws.ec2.model.BaselineEbsBandwidthMbpsRequest.wrap(value)
        )
    override val acceleratorTypes
        : Option[List[zio.aws.ec2.model.AcceleratorType]] = scala
      .Option(impl.acceleratorTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AcceleratorType.wrap(item)
        }.toList
      )
    override val acceleratorCount
        : Option[zio.aws.ec2.model.AcceleratorCountRequest.ReadOnly] = scala
      .Option(impl.acceleratorCount())
      .map(value => zio.aws.ec2.model.AcceleratorCountRequest.wrap(value))
    override val acceleratorManufacturers
        : Option[List[zio.aws.ec2.model.AcceleratorManufacturer]] = scala
      .Option(impl.acceleratorManufacturers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AcceleratorManufacturer.wrap(item)
        }.toList
      )
    override val acceleratorNames
        : Option[List[zio.aws.ec2.model.AcceleratorName]] = scala
      .Option(impl.acceleratorNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AcceleratorName.wrap(item)
        }.toList
      )
    override val acceleratorTotalMemoryMiB
        : Option[zio.aws.ec2.model.AcceleratorTotalMemoryMiBRequest.ReadOnly] =
      scala
        .Option(impl.acceleratorTotalMemoryMiB())
        .map(value =>
          zio.aws.ec2.model.AcceleratorTotalMemoryMiBRequest.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceRequirementsRequest
  ): zio.aws.ec2.model.InstanceRequirementsRequest.ReadOnly = new Wrapper(impl)
}
