package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InferenceAcceleratorInfo(
    accelerators: Option[Iterable[zio.aws.ec2.model.InferenceDeviceInfo]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InferenceAcceleratorInfo = {
    import InferenceAcceleratorInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InferenceAcceleratorInfo
      .builder()
      .optionallyWith(
        accelerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accelerators)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InferenceAcceleratorInfo.ReadOnly =
    zio.aws.ec2.model.InferenceAcceleratorInfo.wrap(buildAwsValue())
}
object InferenceAcceleratorInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InferenceAcceleratorInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InferenceAcceleratorInfo =
      zio.aws.ec2.model.InferenceAcceleratorInfo(
        accelerators.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accelerators
        : Option[List[zio.aws.ec2.model.InferenceDeviceInfo.ReadOnly]]
    def getAccelerators: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InferenceDeviceInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("accelerators", accelerators)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InferenceAcceleratorInfo
  ) extends zio.aws.ec2.model.InferenceAcceleratorInfo.ReadOnly {
    override val accelerators
        : Option[List[zio.aws.ec2.model.InferenceDeviceInfo.ReadOnly]] = scala
      .Option(impl.accelerators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InferenceDeviceInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InferenceAcceleratorInfo
  ): zio.aws.ec2.model.InferenceAcceleratorInfo.ReadOnly = new Wrapper(impl)
}
