package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{NextToken, GVCDMaxResults}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetVpnConnectionDeviceTypesRequest(
    maxResults: Option[GVCDMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesRequest = {
    import GetVpnConnectionDeviceTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => GVCDMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetVpnConnectionDeviceTypesRequest.ReadOnly =
    zio.aws.ec2.model.GetVpnConnectionDeviceTypesRequest.wrap(buildAwsValue())
}
object GetVpnConnectionDeviceTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetVpnConnectionDeviceTypesRequest =
      zio.aws.ec2.model.GetVpnConnectionDeviceTypesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[GVCDMaxResults]
    def nextToken: Option[NextToken]
    def getMaxResults: ZIO[Any, AwsError, GVCDMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesRequest
  ) extends zio.aws.ec2.model.GetVpnConnectionDeviceTypesRequest.ReadOnly {
    override val maxResults: Option[GVCDMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.GVCDMaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesRequest
  ): zio.aws.ec2.model.GetVpnConnectionDeviceTypesRequest.ReadOnly =
    new Wrapper(impl)
}
